% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{de_counts}
\alias{de_counts}
\title{Visualize differentially expressed gene counts as a stacked barplot.}
\usage{
de_counts(res_list, filename = "de_count_barplot.pdf",
  customLabels = FALSE, theme = 1, returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets created with DESeq2::results(). I.E: list(res1, res2, ..., resN).}

\item{filename}{Output file destination. String. Valid extensions are .pdf and .png.  The data file accompanying this
plot file will have the same name, but will be output as a tab-delimited text file. Output will be written to
the /DE/counts/ directory. Alternatively, file generation can be turned off using set_output_mode("screen").}

\item{customLabels}{If customLabels is set to TRUE, the user will be prompted to provide a custom label for each label on the x-axis.}

\item{theme}{The color and design scheme for the output plot.  Valid selections are integers between 1-6.}

\item{returnData}{Boolean.  Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
A data frame containing count information for both up and down regulated gene counts for each result set
provided in res_list.  Output files will be written to /DE/counts/.
}
\description{
This function generates a stacked barplot representing differentially expressed gene counts for a result sets,
distinguishing up and down regulated genes across one or more result sets.
This function will produce a stacked barplot and an output file containing count information.
Count data for the provided result sets will also be returned by this function.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Visualize count data for the result set and save the results.
de_counts(res_set=myResList, filename="DE_counts.png", theme=2)

}
}
\seealso{
\code{\link{create_dir_struct}}, \code{\link{set_output_mode}}
}
\keyword{DE}
\keyword{counts}
\keyword{summary}
\keyword{visualization}
