% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEM1.R
\name{DEM1}
\alias{DEM1}
\title{The DEM1 algorithm is a divide and conquer algorithm, which is used to solve the parameter estimation of multivariate Gaussian mixture model.}
\usage{
DEM1(y, M, seed, alpha0, mu0, sigma0, i, epsilon)
}
\arguments{
\item{y}{is a data matrix}

\item{M}{is the number of subsets}

\item{seed}{is the recommended way to specify seeds}

\item{alpha0}{is the initial value of the mixing weight}

\item{mu0}{is the initial value of the mean}

\item{sigma0}{is the initial value of the covariance}

\item{i}{is the number of iterations}

\item{epsilon}{is the threshold value}
}
\value{
DEM1alpha,DEM1mu,DEM1sigma,DEM1time
}
\description{
The DEM1 algorithm is a divide and conquer algorithm, which is used to solve the parameter estimation of multivariate Gaussian mixture model.
}
\examples{
library(mvtnorm)
alpha1= c(rep(1/4,4)) 
mu1=matrix(0,nrow=4,ncol=4) 
for (k in 1:4){
mu1[4,]=c(runif(4,(k-1)*3,k*3)) 
}
sigma1=list()
for (k in 1:4){
sigma1[[k]]= diag(4)*0.1
}
y= matrix(0,nrow=200,ncol=4) 
for(k in 1:4){
y[c(((k-1)*200/4+1):(k*200/4)),] = rmvnorm(200/4,mu1[k,],sigma1[[k]]) 
}
M=5
seed=123
alpha0= alpha1
mu0=mu1
sigma0=sigma1
i=10
epsilon=0.005
DEM1(y,M,seed,alpha0,mu0,sigma0,i,epsilon)
}
