% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-unquote-identifier.R
\docType{data}
\name{spec_sql_unquote_identifier}
\alias{spec_sql_unquote_identifier}
\title{spec_sql_unquote_identifier}
\value{
\code{dbUnquoteIdentifier()} returns a list of objects
of the same length as the input.
For an empty character vector this function returns a length-0 object.
The names of the input argument are preserved in the output.
When passing the first element of a returned object again to
\code{dbUnquoteIdentifier()} as \code{x}
argument, it is returned unchanged (but wrapped in a list).
Passing objects of class \link{Id} should also return them unchanged (but wrapped in a list).
(For backends it may be most convenient to return \link{Id} objects
to achieve this behavior, but this is not required.)

An error is raised if plain character vectors are passed as the \code{x}
argument.
}
\description{
spec_sql_unquote_identifier
}
\section{Specification}{

For any character vector of length one, quoting (with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}})
then unquoting then quoting the first element is identical to just quoting.
This is also true for strings that
contain special characters such as a space,
a dot,
a comma,
or quotes used to mark strings
or identifiers,
if the database supports this.

Unquoting simple strings (consisting of only letters) wrapped with \code{\link[=SQL]{SQL()}}
and then quoting via \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} gives the same result as just
quoting the string.
Similarly, unquoting expressions of the form \code{SQL("schema.table")}
and then quoting gives the same result as quoting the identifier
constructed by \code{Id(schema = "schema", table = "table")}.
}

\keyword{internal}
