% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-meta.R
\name{test_meta}
\alias{test_meta}
\title{Test metadata functions}
\usage{
test_meta(skip = NULL, ctx = get_default_context())
}
\arguments{
\item{skip}{\code{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.}

\item{ctx}{\code{[DBItest_context]}\cr A test context as created by
\code{\link{make_context}}.}
}
\description{
Test metadata functions
}
\details{
This function defines the following tests:
\describe{
\item{\code{is_valid_connection}}{
Only an open connection is valid.
}
\item{\code{is_valid_result}}{
Only an open result set is valid.
}
\item{\code{get_statement}}{
SQL query can be retrieved from the result.
}
\item{\code{column_info}}{
Column information is correct.
}
\item{\code{row_count}}{
Row count information is correct.
}
\item{\code{rows_affected}}{
Information on affected rows is correct.
}
\item{\code{get_info_result}}{
Return value of dbGetInfo has necessary elements
}
\item{\code{bind_empty_positional_qm}}{
Empty positional binding (question mark syntax) with check of
return value.
}
\item{\code{bind_error_positional_qm}}{
Positional binding of integer values (question mark syntax) raises an
error if connection is closed.
}
\item{\code{bind_return_value_positional_qm}}{
Positional binding of integer values (question mark syntax) with check of
return value.
}
\item{\code{bind_too_many_positional_qm}}{
Positional binding of integer values (question mark syntax) with too many
values.
}
\item{\code{bind_not_enough_positional_qm}}{
Positional binding of integer values (question mark syntax) with too few
values.
}
\item{\code{bind_integer_positional_qm}}{
Positional binding of integer values (question mark syntax).
}
\item{\code{bind_numeric_positional_qm}}{
Positional binding of numeric values (question mark syntax).
}
\item{\code{bind_logical_positional_qm}}{
Positional binding of logical values (question mark syntax).
}
\item{\code{bind_logical_int_positional_qm}}{
Positional binding of logical values (coerced to integer, question mark
syntax).
}
\item{\code{bind_null_positional_qm}}{
Positional binding of \code{NULL} values (question mark syntax).
}
\item{\code{bind_character_positional_qm}}{
Positional binding of character values (question mark syntax).
}
\item{\code{bind_date_positional_qm}}{
Positional binding of date values (question mark syntax).
}
\item{\code{bind_timestamp_positional_qm}}{
Positional binding of timestamp values (question mark syntax).
}
\item{\code{bind_timestamp_lt_positional_qm}}{
Positional binding of \code{\link{POSIXlt}} timestamp values (question
mark syntax).
}
\item{\code{bind_raw_positional_qm}}{
Positional binding of raw values (question mark syntax).
}
\item{\code{bind_empty_positional_dollar}}{
Empty positional binding (dollar syntax) with check of
return value.
}
\item{\code{bind_error_positional_dollar}}{
Positional binding of integer values (dollar syntax) raises an
error if connection is closed.
}
\item{\code{bind_return_value_positional_dollar}}{
Positional binding of integer values (dollar syntax) with check of
return value.
}
\item{\code{bind_too_many_positional_dollar}}{
Positional binding of integer values (dollar syntax) with too many
values.
}
\item{\code{bind_not_enough_positional_dollar}}{
Positional binding of integer values (dollar syntax) with too few
values.
}
\item{\code{bind_repeated_positional_dollar}}{
Positional binding of integer values (dollar syntax), repeated.
}
\item{\code{bind_integer_positional_dollar}}{
Positional binding of integer values (dollar syntax).
}
\item{\code{bind_numeric_positional_dollar}}{
Positional binding of numeric values (dollar syntax).
}
\item{\code{bind_logical_positional_dollar}}{
Positional binding of logical values (dollar syntax).
}
\item{\code{bind_logical_int_positional_dollar}}{
Positional binding of logical values (coerced to integer, dollar
syntax).
}
\item{\code{bind_null_positional_dollar}}{
Positional binding of \code{NULL} values (dollar syntax).
}
\item{\code{bind_character_positional_dollar}}{
Positional binding of character values (dollar syntax).
}
\item{\code{bind_date_positional_dollar}}{
Positional binding of date values (dollar syntax).
}
\item{\code{bind_timestamp_positional_dollar}}{
Positional binding of timestamp values (dollar syntax).
}
\item{\code{bind_timestamp_lt_positional_dollar}}{
Positional binding of \code{\link{POSIXlt}} timestamp values (dollar
syntax).
}
\item{\code{bind_raw_positional_dollar}}{
Positional binding of raw values (dollar syntax).
}
\item{\code{bind_empty_named_colon}}{
Empty named binding (colon syntax) with check of
return value.
}
\item{\code{bind_error_named_colon}}{
named binding of integer values (colon syntax) raises an
error if connection is closed.
}
\item{\code{bind_return_value_named_colon}}{
named binding of integer values (colon syntax) with check of
return value.
}
\item{\code{bind_too_many_named_colon}}{
named binding of integer values (colon syntax) with too many
values.
}
\item{\code{bind_not_enough_named_colon}}{
named binding of integer values (colon syntax) with too few
values.
}
\item{\code{bind_wrong_name_named_colon}}{
named binding of integer values (colon syntax) with wrong names.
}
\item{\code{bind_repeated_named_colon}}{
Named binding of integer values (colon syntax), repeated.
}
\item{\code{bind_integer_named_colon}}{
Named binding of integer values (colon syntax).
}
\item{\code{bind_numeric_named_colon}}{
Named binding of numeric values (colon syntax).
}
\item{\code{bind_logical_named_colon}}{
Named binding of logical values (colon syntax).
}
\item{\code{bind_logical_int_named_colon}}{
Named binding of logical values (coerced to integer, colon
syntax).
}
\item{\code{bind_null_named_colon}}{
Named binding of \code{NULL} values (colon syntax).
}
\item{\code{bind_character_named_colon}}{
Named binding of character values (colon syntax).
}
\item{\code{bind_date_named_colon}}{
Named binding of date values (colon syntax).
}
\item{\code{bind_timestamp_named_colon}}{
Named binding of timestamp values (colon syntax).
}
\item{\code{bind_timestamp_lt_named_colon}}{
Named binding of \code{\link{POSIXlt}} timestamp values (colon
syntax).
}
\item{\code{bind_raw_named_colon}}{
Named binding of raw values (colon syntax).
}
\item{\code{bind_empty_named_dollar}}{
Empty named binding (dollar syntax) with check of
return value.
}
\item{\code{bind_error_named_dollar}}{
named binding of integer values (dollar syntax) raises an
error if connection is closed.
}
\item{\code{bind_return_value_named_dollar}}{
named binding of integer values (dollar syntax) with check of
return value.
}
\item{\code{bind_too_many_named_dollar}}{
named binding of integer values (dollar syntax) with too many
values.
}
\item{\code{bind_not_enough_named_dollar}}{
named binding of integer values (dollar syntax) with too few
values.
}
\item{\code{bind_wrong_name_named_dollar}}{
named binding of integer values (dollar syntax) with wrong names.
}
\item{\code{bind_repeated_named_dollar}}{
Named binding of integer values (dollar syntax), repeated.
}
\item{\code{bind_integer_named_dollar}}{
Named binding of integer values (dollar syntax).
}
\item{\code{bind_numeric_named_dollar}}{
Named binding of numeric values (dollar syntax).
}
\item{\code{bind_logical_named_dollar}}{
Named binding of logical values (dollar syntax).
}
\item{\code{bind_logical_int_named_dollar}}{
Named binding of logical values (coerced to integer, dollar
syntax).
}
\item{\code{bind_null_named_dollar}}{
Named binding of \code{NULL} values (dollar syntax).
}
\item{\code{bind_character_named_dollar}}{
Named binding of character values (dollar syntax).
}
\item{\code{bind_date_named_dollar}}{
Named binding of date values (dollar syntax).
}
\item{\code{bind_timestamp_named_dollar}}{
Named binding of timestamp values (dollar syntax).
}
\item{\code{bind_timestamp_lt_named_dollar}}{
Named binding of \code{\link{POSIXlt}} timestamp values (dollar
syntax).
}
\item{\code{bind_raw_named_dollar}}{
Named binding of raw values (dollar syntax).
}
}
}
\seealso{
Other tests: \code{\link{test_compliance}},
  \code{\link{test_connection}}, \code{\link{test_driver}},
  \code{\link{test_getting_started}},
  \code{\link{test_result}}, \code{\link{test_sql}}
}

