% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBDriver.R
\name{dbDataType}
\alias{dbDataType}
\title{Determine the SQL data type of an object}
\usage{
dbDataType(dbObj, obj, ...)
}
\arguments{
\item{dbObj}{A object inheriting from \linkS4class{DBIDriver}
or \linkS4class{DBIConnection}}

\item{obj}{An R object whose SQL type we want to determine.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbDataType()} returns the SQL type that corresponds to the \code{obj} argument
as a non-empty
character string.
For data frames, a character vector with one element per column
is returned.
An error is raised for invalid values for the \code{obj} argument such as a
\code{NULL} value.
}
\description{
Returns an SQL string that describes the SQL data type to be used for an
object.
The default implementation of this generic determines the SQL type of an
R object according to the SQL 92 specification, which may serve as a starting
point for driver implementations. DBI also provides an implementation
for data.frame which will return a character vector giving the type for each
column in the dataframe.
}
\details{
The data types supported by databases are different than the data types in R,
but the mapping between the primitive types is straightforward:
\itemize{
\item Any of the many fixed and varying length character types are mapped to
character vectors
\item Fixed-precision (non-IEEE) numbers are mapped into either numeric or
integer vectors.
}

Notice that many DBMS do not follow IEEE arithmetic, so there are potential
problems with under/overflows and loss of precision.
}
\section{Specification}{


The backend can override the \code{\link[=dbDataType]{dbDataType()}} generic
for its driver class.

This generic expects an arbitrary object as second argument.
To query the values returned by the default implementation,
run \code{example(dbDataType, package = "DBI")}.
If the backend needs to override this generic,
it must accept all basic R data types as its second argument, namely
\link{logical},
\link{integer},
\link{numeric},
\link{character},
dates (see \link{Dates}),
date-time (see \link{DateTimeClasses}),
and \link{difftime}.
It also must accept lists of \link{raw} vectors
and map them to the BLOB (binary large object) data type,
unless the \code{omit_blob_tests} tweak is set to \code{TRUE}.
As-is objects (i.e., wrapped by \code{\link[=I]{I()}}) must be
supported and return the same results as their unwrapped counterparts.
The SQL data type for \link{factor}
and \link{ordered} is the same as for character.
The behavior for other object types is not specified.




All data types returned by \code{dbDataType()} are usable in an SQL statement
of the form
\code{"CREATE TABLE test (a ...)"}.

}

\examples{
dbDataType(ANSI(), 1:5)
dbDataType(ANSI(), 1)
dbDataType(ANSI(), TRUE)
dbDataType(ANSI(), Sys.Date())
dbDataType(ANSI(), Sys.time())
dbDataType(ANSI(), Sys.time() - as.POSIXct(Sys.Date()))
dbDataType(ANSI(), c("x", "abc"))
dbDataType(ANSI(), list(raw(10), raw(20)))
dbDataType(ANSI(), I(3))

dbDataType(ANSI(), iris)

con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbDataType(con, 1:5)
dbDataType(con, 1)
dbDataType(con, TRUE)
dbDataType(con, Sys.Date())
dbDataType(con, Sys.time())
dbDataType(con, Sys.time() - as.POSIXct(Sys.Date()))
dbDataType(con, c("x", "abc"))
dbDataType(con, list(raw(10), raw(20)))
dbDataType(con, I(3))

dbDataType(con, iris)

dbDisconnect(con)
}
\seealso{
Other DBIDriver generics: \code{\link{DBIDriver-class}},
  \code{\link{dbConnect}}, \code{\link{dbDriver}},
  \code{\link{dbGetInfo}}, \code{\link{dbIsValid}},
  \code{\link{dbListConnections}}

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDisconnect}}, \code{\link{dbExecute}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
