% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{panel.2cat}
\alias{panel.2cat}
\title{Lattice panel function for confidence intervals with capped bars}
\usage{
panel.2cat(x, y, subscripts, lower, upper, length = 0.2)
}
\arguments{
\item{x, y}{Data from the call to \code{xyplot}.}

\item{subscripts}{Variable used to created the juxtaposed panels.}

\item{lower, upper}{95\% lower and upper bounds of \code{y}.}

\item{length}{Length of the arrow head lines.}
}
\description{
This panel function is defined to plot confidence intervals in a multi-panel
lattice display where the x-variable is categorical. Note, both lower and
upper must be passed directly to \code{xyplot} as they will be passed down
to the panel function.
}
\examples{

library(lattice)
library(effects)
data(Duncan, package="carData")
Duncan$inc.cat <- cut(Duncan$income, 3)
mod <- lm(prestige~ inc.cat * type + education,
  data=Duncan)
e1 <- effect("inc.cat*type", mod)
update(plot(e1), panel=panel.2cat)

}
\author{
Dave Armstrong
}
