% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{testLoess}
\alias{testLoess}
\title{Significance Test for Loess vs. LM}
\usage{
testLoess(lmobj, loessobj, alpha = 0.05)
}
\arguments{
\item{lmobj}{An object of class \code{lm}.}

\item{loessobj}{An object of class \code{loess}.}

\item{alpha}{Desired Type I error rate of test.}
}
\value{
Printed output describing the results of the test.
}
\description{
Calculates an F test to evaluate significant differences between a LOESS
model and a parametric alternative estimated with \code{lm}
}
\examples{

data(Prestige, package="carData")
linmod <- lm(prestige ~ income, data=Prestige)
lomod <- loess(prestige ~ income, data=Prestige)
testLoess(linmod, lomod)

}
\author{
Dave Armstrong
}
