% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.training_test_comparison.R
\name{plot.training_test_comparison}
\alias{plot.training_test_comparison}
\title{Plot and compare performance of model between training and test set}
\usage{
\method{plot}{training_test_comparison}(x, ...)
}
\arguments{
\item{x}{- object created with \code{\link{training_test_comparison}} function.}

\item{...}{- other parameters}
}
\value{
ggplot object
}
\description{
Function \code{plot.training_test_comparison} plots dependecy between model performance on test and trainig dataset based on
\code{training_test_comparison} object. Green line indicates \code{y = x} line.
}
\examples{

library("mlr")
library("DALEXtra")
task <- mlr::makeRegrTask(
 id = "R",
  data = apartments,
   target = "m2.price"
)
 learner_lm <- mlr::makeLearner(
 "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
"regr.randomForest"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
"regr.gbm"
)
model_gbm <- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "GBM")

data <- training_test_comparison(explainer_lm, list(explainer_gbm, explainer_rf),
                                 training_data = apartments,
                                 training_y = apartments$m2.price)
plot(data)

}
