% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_data.R
\docType{data}
\name{stac_table}
\alias{stac_table}
\title{Explanatory table on meaning and use of \code{stac} settings}
\format{
A table with 9 rows and 5 columns.
}
\description{
A table containing the information regarding the meaning
of the \code{stac} codes utilised by DAISIE's ML functions. It is used to
render the "DAISIE \code{stac} values" vignette. \cr \cr
\code{stac} stands for "status of the clade" formed by the immigrant. It is
an important part of DAISIE objects that informs the likelihood functions
about the endemicity status and type of data available for each insular
clade. Each colonisation event that has extant species on the island needs to
have a \code{stac} value specified. This also has implications in what is
included in the DAISIE object \code{"branching_times"} vector, which also
described in this table.
The table is composed of the following columns:
\itemize{
  \item{$stac: A numeric with each stac code from 1 until 9.}
  \item{$Input for DAISIE_dataprep table "Clade_Name": A character
  with the possibilities for input in \link{DAISIE_dataprep}()
  of each clade, which are then translated to a numeric \code{stac} code as
  in \code{$stac}.}
  \item{$Type of species or clade": A character
  with the plain English explanation of the different possible kinds of
  island lineages that can be considered by DAISIE.}
  \item{$Input for DAISIE_dataprep table "Branching_times": A
  character with the plain English explanation of what the branching times
  vector in the DAISIE object should contain.}
  \item{$Colonisation times: A character with the plain English
  explanation of what the colonisation time in the branching times vector
  of the DAISIE object (first element of the vector) means.}
}
}
\keyword{datasets}
