% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{D2C.network-class}
\alias{D2C.network-class}
\title{An S4 class to represent a directed acyclic graph and its functional dependency.}
\description{
An S4 class to represent a directed acyclic graph and its functional dependency.
}
\examples{
\dontrun{
require(D2C)
require(gRbase)
require(RBGL)
H_Rn <- function(n)
{
  a = runif(n+1,min = -1,max = 1)
  f <- function(x)
  {
    X  = x^(0:n)
    return ( sum(X * a))
  }
  return(Vectorize(f))
}
H = function() return(H_Rn(1))
#H is a function that return a linear function example :

a = H() ; b= H() ;
print(a(-10:10)) ;
print(b(-10:10)) ;
#

sdn=0.5
sigma=function(x) return(rnorm(n = 1,sd = sdn))
DAG = new("D2C.network",network=random_dag(1:50,maxpar = 5,wgt=0.8),H=H,sdn=sdn,sigma=sigma)
X = compute(DAG,N=150)

#DAG is a network that contains the graph and the functional dependency
plot(DAG@network)
#DAG contains node and edges attribute.
#nodes attributes : bias the bias of a node , sigma the noise
#edges attributes :  H the dependency function
}
}

