% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{createControl}
\alias{createControl}
\title{Create a Cyclops control object}
\usage{
createControl(
  maxIterations = 1000,
  tolerance = 1e-06,
  convergenceType = "gradient",
  cvType = "auto",
  fold = 10,
  lowerLimit = 0.01,
  upperLimit = 20,
  gridSteps = 10,
  cvRepetitions = 1,
  minCVData = 100,
  noiseLevel = "silent",
  threads = 1,
  seed = NULL,
  resetCoefficients = FALSE,
  startingVariance = -1,
  useKKTSwindle = FALSE,
  tuneSwindle = 10,
  selectorType = "auto",
  initialBound = 2,
  maxBoundCount = 5,
  algorithm = "ccd"
)
}
\arguments{
\item{maxIterations}{Integer: maximum iterations of Cyclops to attempt before returning a failed-to-converge error}

\item{tolerance}{Numeric: maximum relative change in convergence criterion from successive iterations to achieve convergence}

\item{convergenceType}{String: name of convergence criterion to employ (described in more detail below)}

\item{cvType}{String: name of cross validation search.
Option \code{"auto"} selects an auto-search following BBR.
Option \code{"grid"} selects a grid-search cross validation}

\item{fold}{Numeric: Number of random folds to employ in cross validation}

\item{lowerLimit}{Numeric: Lower prior variance limit for grid-search}

\item{upperLimit}{Numeric: Upper prior variance limit for grid-search}

\item{gridSteps}{Numeric: Number of steps in grid-search}

\item{cvRepetitions}{Numeric: Number of repetitions of X-fold cross validation}

\item{minCVData}{Numeric: Minimum number of data for cross validation}

\item{noiseLevel}{String: level of Cyclops screen output (\code{"silent"}, \code{"quiet"}, \code{"noisy"})}

\item{threads}{Numeric: Specify number of CPU threads to employ in cross-validation; default = 1 (auto = -1)}

\item{seed}{Numeric: Specify random number generator seed. A null value sets seed via \code{\link{Sys.time}}.}

\item{resetCoefficients}{Logical: Reset all coefficients to 0 between model fits under cross-validation}

\item{startingVariance}{Numeric: Starting variance for auto-search cross-validation; default = -1 (use estimate based on data)}

\item{useKKTSwindle}{Logical: Use the Karush-Kuhn-Tucker conditions to limit search}

\item{tuneSwindle}{Numeric: Size multiplier for active set}

\item{selectorType}{String: name of exchangeable sampling unit.
Option \code{"byPid"} selects entire strata.
Option \code{"byRow"} selects single rows.
If set to \code{"auto"}, \code{"byRow"} will be used for all models except conditional models where
the average number of rows per stratum is smaller than the number of strata.}

\item{initialBound}{Numeric: Starting trust-region size}

\item{maxBoundCount}{Numeric: Maximum number of tries to decrease initial trust-region size}

\item{algorithm}{String: name of fitting algorithm to employ; default is `ccd`

Todo: Describe convegence types}
}
\value{
A Cyclops control object of class inheriting from \code{"cyclopsControl"} for use with \code{\link{fitCyclopsModel}}.
}
\description{
\code{createControl} creates a Cyclops control object for use with \code{\link{fitCyclopsModel}}.
}
\examples{
#Generate some simulated data:
sim <- simulateCyclopsData(nstrata = 1, nrows = 1000, ncovars = 2, eCovarsPerRow = 0.5, 
                           model = "poisson")
cyclopsData <- convertToCyclopsData(sim$outcomes, sim$covariates, modelType = "pr", 
                                    addIntercept = TRUE)

#Define the prior and control objects to use cross-validation for finding the 
#optimal hyperparameter:
prior <- createPrior("laplace", exclude = 0, useCrossValidation = TRUE)
control <- createControl(cvType = "auto", noiseLevel = "quiet")

#Fit the model
fit <- fitCyclopsModel(cyclopsData,prior = prior, control = control)  

#Find out what the optimal hyperparameter was:
getHyperParameter(fit)

#Extract the current log-likelihood, and coefficients
logLik(fit)
coef(fit)

#We can only retrieve the confidence interval for unregularized coefficients:
confint(fit, c(0))
}
