\name{TBT.criticalValue}
\alias{TBT.criticalValue}

\title{
Critical value for Topological Binary Test
}
\description{
Approximately computes cumulative distribution function of the test statistic of the Topological Binary Test of Alcover et al. (2013) and finds the required critical value for the test. 
}
\usage{
  TBT.criticalValue(m, k, alpha = 0.01, cdf = FALSE, exact = TRUE)
}
\arguments{
  \item{m}{
    the length of words (B-bit) in Topological Binary Test.
}
  \item{k}{
   the number of words (integers) generated by the RNG of interest that will be tested.
}
  \item{alpha}{
   a predetermined value of type-I error with the default value of 0.05.
}
  \item{cdf}{
   if \code{TRUE}, the cumulative distribution function of the test statistic is stored and printed.
}
  \item{exact}{
   if \code{TRUE}, the function \code{Stirling2} from the package \pkg{gmp} is used to calculate the Stirling numbers of the second kind in the case that the function \code{Strlng2} from the package \pkg{CryptRndTest} returns a \code{NaN}. Otherwise, nothing is done for \code{NaN}'s generated by \code{Strlng2}. 
}
}
\details{
The function \code{TBT.criticalValue} lists the cumulative probabilities greater than zero if \code{cdf} is set to \code{TRUE}. 

A correction factor is applied to improve accuracy of the the function \code{Strlng2} in the computation of probabilities. Accuracy of the computations decreases with increasing value of \code{m}.
}
\value{
\item{prob}{
     a vector containing the cumulative probabilities corresponding to the values in \code{value}.
}
\item{value}{
     a vector containing the values of the test statistic.
}
\item{critical.value}{
     critical value of the test statistic corresponding to \code{alpha}.
}
}
\references{
Alcover, P.M., Guillamon, A., Ruiz, M.C., A new randomness test for bit sequences. Informatica  (2013), 24(3), 339--356. 
}
\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydarde@hacettepe.edu.tr>
}

\examples{
# Critical values for the Topological Binary Test at 0.01 and 0.05 levels of significance.

TBT.criticalValue(m=8, k=256, alpha=0.01, cdf=FALSE, exact=FALSE)
TBT.criticalValue(m=8, k=256, alpha=0.05, cdf=FALSE, exact=FALSE)
}

\keyword{critical value }