/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.contrast;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.commons.widgets.WidgetFactory;
import org.af.jhlir.call.RMatrixDouble;
import org.mutoss.gui.RControl;
import org.mutoss.gui.contrast.ContrastTable;
import org.mutoss.gui.contrast.GroupingBox;
import org.mutoss.gui.contrast.LevelOrderSL;
import org.mutoss.gui.contrast.ROptionBox;
import org.mutoss.gui.contrast.SharedDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContrastDialog
extends SharedDialog
implements ActionListener {
    private GroupingBox cbGroup;
    private LevelOrderSL slLevelOrder;
    private ROptionBox<String> cbType;
    private ContrastTable pTable;
    private JButton jbAdd;
    private JButton jbScaleCM;
    public JLabel jlInfo;

    public ContrastDialog(JFrame window, GroupingBox cbGroup, LevelOrderSL slLevelOrder) {
        super(window, "Contrast Building");
        this.cbGroup = cbGroup;
        this.slLevelOrder = slLevelOrder;
        this.jbAdd = new JButton("Add Contrast");
        this.jbAdd.addActionListener(this);
        this.jbScaleCM = new JButton("Scale contrasts");
        this.jbScaleCM.addActionListener(this);
        this.jlInfo = new JLabel("Please add contrasts.");
        this.pTable = new ContrastTable(this.df, cbGroup, slLevelOrder, this.jlInfo);
        String[] a = new String[]{"Dunnett", "Tukey", "Sequen", "AVE", "Changepoint", "Williams", "Marcus", "McDermott", "UmbrellaWilliams", "GrandMean"};
        String[] b = new String[]{"Dunnett", "Tukey", "Sequen", "AVE", "Changepoint", "Williams", "Marcus", "McDermott", "UmbrellaWilliams", "GrandMean"};
        this.cbType = new ROptionBox<String>("type", a, b);
        JPanel panel = new JPanel();
        panel.add(this.jbAdd);
        panel.add(this.jbScaleCM);
        Object[] labels = new String[]{"Type", null, "Contrasts", null};
        Component[] comps = new Component[]{this.cbType, panel, new JScrollPane((Component)((Object)this.pTable)), this.jlInfo};
        this.setContent(labels, comps);
        this.setModal(true);
        this.doTheLayout();
        this.pack();
        WidgetFactory.showCompleteTitle((JDialog)this);
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void checkConstraints() {
        this.requiresFactVar();
    }

    public RMatrixDouble showAndGetMatrix() {
        this.setVisible(true);
        this.dispose();
        return this.getMatrix();
    }

    public RMatrixDouble getContrastMatrix(String varname, String type, List<String> list) {
        return RControl.getR().eval("m <- myContrMat(df=df, group=\"" + varname + "\", type=\"" + type + "\",l=list").asRMatrixDouble();
    }

    public RMatrixDouble getMatrix() {
        return null;
    }

    @Override
    protected void onOk() {
        String group = this.cbGroup.getSelectedItem().toString();
        List levelOrder = this.slLevelOrder.getRight();
        String type = (String)this.cbType.getSelectedObject();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource().equals(this.jbAdd)) {
            RMatrixDouble m = this.getContrastMatrix(this.cbGroup.getSelectedItem().toString(), (String)this.cbType.getSelectedObject(), this.slLevelOrder.getRight());
            try {
                this.pTable.addMatrix(m);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource().equals(this.jbScaleCM)) {
            this.pTable.scale();
        }
    }
}

