% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{sen.ci}
\alias{sen.ci}
\title{Point estimate and confidence interval for sensitivity analysis}
\usage{
sen.ci(d, mm = c(2, 2, 2), gamma = 1, alpha = 0.05, alpha.up = alpha/2,
  alpha.low = alpha/2, score.method = c("approximate", "exact"))
}
\arguments{
\item{d}{a vector of treatment-minus-control differences}

\item{mm}{a vector (m, munder, mover) that indicates the U-statistic. Does not support matrix \code{mm} in this function.}

\item{gamma}{a vector of sensitivity parameters (must be >= 1).}

\item{alpha}{significance level for the outer confidence interval}

\item{alpha.up}{upper-tail probability of the confidence interval}

\item{alpha.low}{lower-tail probability of the confidence interval}

\item{score.method}{either approximate score or exact score}
}
\value{
a list
\describe{
\item{point.estimate}{An interval of point estimates allowing for a bias of gamma in treatment assignment.}
\item{ci}{An confidence interval allowing for a bias of gamma in treatment assignment.}
}
}
\description{
Point estimate and confidence interval for sensitivity analysis
}
\details{
See the \code{senmwCI} function in the \code{sensitivitymw} package.
}
\examples{
data(lead)
d.lead <- lead$exposed[-21] - lead$control[-21]
sen.ci(d.lead, gamma = c(1, 2), alpha.up = 0, alpha.low = 0.05)

}
\author{
Qingyuan Zhao
}

