% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{sen}
\alias{sen}
\title{Sensivity analysis with signed score test}
\usage{
sen(y, mm = NULL, gamma = 1, tail = c("upper", "lower"))
}
\arguments{
\item{y}{a vector of treatment-minus-control differences}

\item{mm}{a vector (m, munder, mover) that indicates the U-statistic. NULL means Wilcoxon's signed rank test.}

\item{gamma}{sensitivity parameter >= 1.}

\item{tail}{report p-value corresponds to the maximum ("upper") or minimum ("lower") bound}
}
\value{
A list
\describe{
\item{pval}{p-value}
\item{pval2}{two sided p-value}
\item{T}{test statistic}
\item{E}{Mean of the test statistic under sensivity gamma}
\item{V}{Variance of the test statistic under sensitivity gamma}
\item{devc}{Effect size of T compared to E and V}
}
}
\description{
Sensivity analysis with signed score test
}
\author{
Paul Rosenbaum, Qingyuan Zhao
}

