% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_cox.event}
\alias{plot_cox.event}
\title{plot_cox.event}
\usage{
plot_cox.event(model, type = "lp", n.breaks = 20)
}
\arguments{
\item{model}{Coxmos model.}

\item{type}{Character. Prediction type: "lp", "risk", "expected" or "survival" (default: "lp").}

\item{n.breaks}{Numeric. If BREAKTIME is NULL, "n.breaks" is the number of time-break points to
compute (default: 20).}
}
\value{
A list containing three elements:
\code{df}: A data.frame with the computed predictions based on the specified type and the
corresponding event status.
\code{plot.density}: A ggplot object representing the density plot of the event distribution,
with separate curves for censored and occurred events.
\code{plot.histogram}: A ggplot object representing the histogram of the event distribution,
with bins stacked by event type.
}
\description{
Visualizes the distribution of events based on a Coxmos model's predictions. The function provides
both density and histogram plots to elucidate the event distribution, which can be instrumental in
understanding the model's behavior across different prediction types.
}
\details{
The function takes in a Coxmos model and, based on the specified prediction type (\code{lp}, \code{risk},
\code{expected}, or \code{survival}), computes the respective predictions. The \code{lp} (linear predictor) is the
default prediction type. The density and histogram plots are then generated to represent the
distribution of events (censored or occurred) concerning these predictions.

The density plot provides a smoothed representation of the event distribution, with separate curves
for censored and occurred events. This visualization can be particularly useful to discern the
overall distribution and overlap between the two event types.

The histogram, on the other hand, offers a binned representation of the event distribution. Each
bin's height represents the count of observations falling within that prediction range, stacked by
event type. This visualization provides a more granular view of the event distribution across
different prediction values.

It's imperative to note that the models should be run with the \code{returnData = TRUE} option to ensure
the necessary data is available for plotting.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
plot_cox.event(splsicox.model)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
