% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_observation.eventDensity}
\alias{plot_observation.eventDensity}
\title{plot_observation.eventDensity}
\usage{
plot_observation.eventDensity(
  observation,
  model,
  time = NULL,
  type = "lp",
  size = 3,
  color = "red"
)
}
\arguments{
\item{observation}{Numeric matrix or data.frame. New explanatory variables (raw data) for one observation.
Qualitative variables must be transform into binary variables.}

\item{model}{Coxmos model.}

\item{time}{Numeric. Time point where the AUC will be evaluated (default: NULL).}

\item{type}{Character. Prediction type: "lp", "risk", "expected" or "survival" (default: "lp").}

\item{size}{Numeric. Point size (default: 3).}

\item{color}{String. R Color.}
}
\value{
A ggplot object representing a density of the predicted event values based on the
provided Coxmos model.
}
\description{
Visualizes the event density for a given observation's data using the Coxmos model.
}
\details{
The \code{plot_observation.eventDensity} function provides a graphical representation of the event
density for a specific observation's data, based on the Coxmos model. The function computes the density
of events and non-events and plots them, highlighting the predicted value for the given observation's
data. The density is determined using density estimation, and the predicted value is obtained from
the Coxmos model. The function allows customization of the plot aesthetics, such as point size and
color. The resulting plot provides a visual comparison of the observation's predicted event density
against the overall event density distribution, aiding in the interpretation of the observation's risk
profile.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
coxEN.model <- coxEN(X_train, Y_train, x.center = TRUE, x.scale = TRUE)
observation = X_test[1,,drop=FALSE]
plot_observation.eventDensity(observation = observation, model = coxEN.model, time = NULL)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
