% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphlb.R
\name{coxphlb}
\alias{coxphlb}
\title{Fit Cox Model to Right-Censored Length-Biased Data}
\usage{
coxphlb(formula, data, method = c("Bootstrap","EE"),
boot.iter = 500, seed.n = round(runif(1,1,1e09)), digits = 3L)
}
\arguments{
\item{formula}{A formula object with the form \code{response ~ predictors}. For \code{response}, use \code{Surv} object.}

\item{data}{A data frame containing the variables in the model.}

\item{method}{A character string specifying the method for variance estimation. The bootstrap resampling method ("Bootstrap") is used as the default. The estimating equation method ("EE")  uses the asymptotic variance estimation.}

\item{boot.iter}{The number of bootstrap iterations. Default is 500.}

\item{seed.n}{An integer specifying seed number.}

\item{digits}{An integer controlling the number of digits to print.}
}
\value{
A list containing the following components:
\item{coefficients}{The vector of coefficients.}
\item{var}{The variance matrix of the coefficients.}
\item{std.err}{The standard error of the coefficients.}
\item{z.score}{z scores for the coefficients.}
\item{p.value}{p-values for the coefficients.}
\item{lower.95}{Lower 95\% confidence intervals of the coefficients.}
\item{upper.95}{Upper 95\% confidence intervals of the coefficients.}
\item{method}{The approach used to obtain the standard error of the coefficients.}
\item{}{The list is returned as an object of the \code{coxphlb} class to represent a fitted proportional hazards model. Objects of this class have methods for the functions \code{coef}, \code{print}, \code{summary}, and \code{vcov}. The object also contains the following: \code{formula}; \code{varnames}, the variables used in the model; \code{result}, the table output.}
}
\description{
Fits a Cox model to right-censored length-biased data.
}
\details{
This function uses the weighted estimating equation proposed by Qin and Shen (2010). It returns coefficient estimates and the corresponding variance estimates based on either the asymptotic variance or the bootstrap resampling method. It also tests the null hypothesis that the coefficients are equal to 0.
}
\examples{
\dontrun{
# Fit a Cox model using model based variance estimation
fit.ee <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = ExampleData1,
                 method = "EE")
summary(fit.ee)			# display the results

# Fit a Cox model using bootstrap resampling method
fit.bs <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = ExampleData1,
                 method = "Bootstrap", seed.n = 1234)
summary(fit.bs)			# display the results
}
}
\references{
Qin J. and Shen Y. (2010). Statistical Methods for Analyzing Right-Censored Length-Biased Data under Cox Model. \emph{Biometrics} 66(2), 382-392.
}
\seealso{
\code{\link{coxphlb.ftest}}, \code{\link{coxphlb.phtest}}, \code{\link{station.test}}, \code{\link{station.test.plot}}
}
