% Generated by roxygen2 (4.0.1): do not edit by hand
\name{glmTrainPhotoZ}
\alias{glmTrainPhotoZ}
\title{Fit a glm for photometric redshift estimation}
\usage{
glmTrainPhotoZ(x, formula, method, family)
}
\arguments{
\item{x}{a data.frame containing the data to train the model}

\item{formula}{an object of class "formula" to be adopted}

\item{method}{a string containing the chosen glm method. Two options are available: \code{Frequentist} will use the function  \code{\link{glm}} from the package \code{stats}; \code{Bayesian} will use the function \code{\link{bayesglm}} from the package  \code{arm}.}

\item{family}{a string containing \code{gamma} or \code{inverse.gaussian} (a string with a  description of the error distribution and link function to be used in the model).}
}
\value{
a trained glm object containing the fit of the model
}
\description{
\code{glmTrainPhotoZ} trains a generalized linear model for
photometric redshift estimation.
}
\details{
The program is a simple alteration of glm() and bayesglm().
         The new arguments here are: Frequentist, Bayesian.
}
\examples{
\dontrun{
# Load the data
data(PHAT0train)
data(PHAT0test)

# Combine the training and test data and calculate the principal components
PC_comb <- computeCombPCA(subset(PHAT0train, select=c(-redshift)),
           subset(PHAT0test, select=c(-redshift)),
           robust=FALSE) # robust is false here just to make it faster
Trainpc <- cbind(PC_comb$x, redshift=PHAT0train$redshift)
Testpc <- PC_comb$y

# Fitting
Fit <- glmTrainPhotoZ(Trainpc, formula=redshift~poly(Comp.1,2)*
           poly(Comp.2,2)*Comp.3*Comp.4*Comp.5*Comp.6,
           method="Bayesian", family="gamma")

# Perform the photometric redshift estimation
photoz <- predict(Fit$glmfit, newdata=Testpc, type="response")
specz <- PHAT0test$redshift

# Show a plot with the results
plotDiagPhotoZ(photoz, specz, "box")
}
}
\author{
Rafael S. de Souza, Alberto Krone-Martins
}
\keyword{utilities}

