% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorShrinkMatrix.R
\name{CorShrinkMatrix}
\alias{CorShrinkMatrix}
\title{Adaptive shrinkage of a matrix of correlations.}
\usage{
CorShrinkMatrix(cormat, nsamp = NULL, zscore_sd = NULL, thresh_up = 0.99,
  thresh_down = -0.99, image_original = FALSE, image_corshrink = FALSE,
  tol = 1e-06, image.control = list(), optmethod = "mixEM",
  ash.control = list())
}
\arguments{
\item{cormat}{A table of correlations - not necessarily a correlation matrix.
May contain NAs as well.}

\item{nsamp}{An integer or a matrix denoting the number of samples for
each pair of variables over which the correlation has been computed.
If the user specifies \code{zscore_sd}, then \code{nsamp} is set
to NULL and is no longer used.}

\item{zscore_sd}{A matrix of the sandard error of the Fisher z-scores for each pair of
variables. May contain NA-s as well. The NA-s in this matrix must
match with the NAs in the \code{cormat} matrix. If provided, it is
used as default over the the asymptotic formulation using \code{nsamp}.
When set to NULL, asymptotic distribution of the Fisher z-scores is used
using \code{nsamp}.}

\item{thresh_up}{Upper threshold for correlations. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations. Defaults to -0.99}

\item{image_original}{if TRUE, plots an image of the non-shrunk original matrix
of correlations.}

\item{image_corshrink}{if TRUE, plots an image of the shrunk matrix
of correlations.}

\item{tol}{The tolerance chosen to check how far apart the CorShrink matrix is from the nearest
positive definite matrix before applying PD completion.}

\item{image.control}{Control parameters for the image when
\code{image_original = TRUE} and/or \code{image_corshrink = TRUE}.}

\item{optmethod}{The optimization method for EM algorithm - can be one of
two techniques \code{mixEM} (mixture EM) and \code{mixVBEM}
(mixture Variational Bayes EM) approaches.The default approach
is \code{mixEM}.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
Returns a adaptively shrunk version of the sample correlation matrix before
        and after PD completion.
}
\description{
This function performs adaptive shrinkage of a sample correlation matrix using a
mixture normal prior on Fisher z-scores with wide range of grid variances.
The method is similar to the adaptive shrinkage method for modeling false discovery rates proposed
in Stephens 2016 (see reference).
}
\examples{

cormat <- get(load(system.file("extdata", "corr_matrix.rda",
                   package = "CorShrink")))
nsamp <- get(load(system.file("extdata", "common_samples.rda",
                             package = "CorShrink")))
out <- CorShrinkMatrix(cormat, nsamp, image_corshrink  = TRUE, optmethod = "mixEM")

}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216; doi: http://dx.doi.org/10.1101/038216
}
\keyword{adaptive}
\keyword{correlation}
\keyword{shrinkage,}
