% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MSE_loc.R
\name{MSE_loc}
\alias{MSE_loc}
\title{simple MSE function}
\usage{
MSE_loc(Y = Y, X = X, A = A, intercept = T)
}
\arguments{
\item{Y}{the response variable (vector)}

\item{X}{the dataset (matrix of covariates)}

\item{A}{the vector of coefficients}

\item{intercept}{(boolean) to add a column of 1 to \code{X} if \code{A} contains an intercept and \code{X} doesn't.}
}
\value{
the Mean Squared Error observed on \code{X} when using \code{A} coefficients to predict \code{Y}.
}
\description{
This function computes the MSE (Mean Squared Error) of prediction associated to a vector of coefficients \code{A} used to predict a response variable \code{Y} by linear regression on \code{X}, with an intercept or not.
}
\examples{
\dontrun{
 require(CorReg)
   #dataset generation
   base=mixture_generator(n=15,p=5,valid=100,scale=TRUE)
   X_appr=base$X_appr #learning sample
   Y_appr=base$Y_appr#response variable
   X_test=base$X_test#validation sample
   Y_test=base$Y_test#response variable (validation sample)
   A=lm(Y_appr~X_appr)$coefficients
MSE_loc(Y=Y_appr,X=X_appr,A=A)#MSE on the learning dataset
MSE_loc(Y=Y_test,X=X_test,A=A)#MSE on the validation sample
   }
}

