% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_urb.R
\name{cc_urb}
\alias{cc_urb}
\title{Identify Records Inside Urban Areas}
\usage{
cc_urb(
  x,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  ref = NULL,
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimalLongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimalLatitude}.}

\item{ref}{a SpatVector. Providing the geographic gazetteer
with the urban areas. See details. By default
rnaturalearth::ne_download(scale = 'medium', type = 'urban_areas',
returnclass = "sf"). Can be any \code{SpatVector}, but the
structure must be identical to \code{rnaturalearth::ne_download()}.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records from inside urban areas, based on a geographic
gazetteer. Often records from large databases span substantial time periods
(centuries) and old records might represent habitats which today are replaced
by city area.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
  details and tutorials.
}
\examples{

\dontrun{
x <- data.frame(species = letters[1:10],
                decimalLongitude = runif(100, -180, 180),
                decimalLatitude = runif(100, -90,90))

cc_urb(x)
cc_urb(x, value = "flagged")
}

}
\seealso{
Other Coordinates: 
\code{\link{cc_aohi}()},
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
