% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{drawPrenucleolus}
\alias{drawPrenucleolus}
\title{Draw prenucleolus for 3 or 4 players}
\usage{
drawPrenucleolus(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Prenucleolus")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPrenucleolus draws the prenucleolus for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,3)
drawPrenucleolus(v) 

\donttest{
#Visualization for estate division problem from Babylonian Talmud with E=200,
#see e.g. seminal paper by Aumann & Maschler from 1985 on
#'Game Theoretic Analysis of a Bankruptcy Problem from the Talmud'
library(CoopGame)
v<-bankruptcyGameVector(n=3,d=c(100,200,300),E=200)
drawPrenucleolus(v)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 107--132
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
