/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelHoverPolicy;

public class TabbedHoverUtil {
    public static boolean isDeepestHoverableTabbedPanel(ArrayList arrayList, TabbedPanel tabbedPanel) {
        for (Component component = (Component)arrayList.get(0); component != null; component = component.getParent()) {
            TabbedPanel tabbedPanel2 = null;
            if (component instanceof TabbedPanel) {
                tabbedPanel2 = (TabbedPanel)component;
            }
            if (component instanceof TabbedPanelContentPanel) {
                tabbedPanel2 = ((TabbedPanelContentPanel)component).getTabbedPanel();
            }
            if (tabbedPanel2 == null) continue;
            if (tabbedPanel2 == tabbedPanel) {
                return true;
            }
            if (tabbedPanel2.getProperties().getHoverPolicy() == TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVisibleTabbedPanelChild(Component component) {
        if (component instanceof TabbedPanel && ((TabbedPanel)component).getProperties().getHoverPolicy() != TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!container.getComponent(i).isVisible() || !TabbedHoverUtil.hasVisibleTabbedPanelChild(container.getComponent(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean acceptTabbedPanelHover(TabbedPanelHoverPolicy tabbedPanelHoverPolicy, ArrayList arrayList, TabbedPanel tabbedPanel, Component component) {
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.NO_HOVERED_CHILD) {
            return TabbedHoverUtil.isDeepestHoverableTabbedPanel(arrayList, tabbedPanel);
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.NEVER) {
            return false;
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.ALWAYS || tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) {
            return true;
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.ONLY_WHEN_DEEPEST && component != null) {
            return !TabbedHoverUtil.hasVisibleTabbedPanelChild(component);
        }
        return false;
    }
}

