/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private Border border;
    private boolean last;
    private boolean afterHighlighted;
    private boolean highlighted;
    private boolean drawTopLine;
    private boolean drawBottomLine;
    private int index;
    private boolean tabSpacing;

    public TabLineBorder() {
        this(null);
    }

    public TabLineBorder(Color color) {
        this(color, false);
    }

    public TabLineBorder(Color color, boolean bl) {
        this(color, bl, true);
    }

    public TabLineBorder(boolean bl, boolean bl2) {
        this((Color)null, bl, bl2);
    }

    public TabLineBorder(Color color, boolean bl, boolean bl2) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW), bl, bl2);
    }

    public TabLineBorder(ColorProvider colorProvider, boolean bl, boolean bl2) {
        this.color = colorProvider;
        this.border = new LineBorder();
        this.drawBottomLine = bl;
        this.drawTopLine = bl2;
    }

    public TabLineBorder(Color color, Border border) {
        this(color, border, false);
    }

    public TabLineBorder(Color color, Border border, boolean bl) {
        this(color, bl);
        if (border != null) {
            this.border = new CompoundBorder(this.border, border);
        }
    }

    public TabLineBorder(ColorProvider colorProvider, Border border, boolean bl, boolean bl2) {
        this(colorProvider, bl, bl2);
        if (border != null) {
            this.border = new CompoundBorder(this.border, border);
        }
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.border.paintBorder(component, graphics, n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        return this.border.getBorderInsets(component);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private void initialize(Tab tab) {
        this.index = tab.getTabbedPanel().getTabIndex(tab);
        this.last = this.index == tab.getTabbedPanel().getTabCount() - 1;
        this.afterHighlighted = this.index > 0 && tab.getTabbedPanel().getTabAt(this.index - 1) == tab.getTabbedPanel().getHighlightedTab();
        this.highlighted = tab == tab.getTabbedPanel().getHighlightedTab();
    }

    private class LineBorder
    implements Border {
        LineBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = TabLineBorder.this.color.getColor(component);
            Tab tab = TabbedUtils.getParentTab(component);
            if (tab != null && tab.getTabbedPanel() != null) {
                Direction direction = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
                TabLineBorder.this.tabSpacing = tab.getTabbedPanel().getProperties().getTabSpacing() > 0;
                TabLineBorder.this.initialize(tab);
                if (direction == Direction.UP) {
                    this.paintUpBorder(graphics, n, n2, n3, n4, color);
                } else if (direction == Direction.LEFT) {
                    this.paintLeftBorder(graphics, n, n2, n3, n4, color);
                } else if (direction == Direction.DOWN) {
                    this.paintDownBorder(graphics, n, n2, n3, n4, color);
                } else {
                    this.paintRightBorder(graphics, n, n2, n3, n4, color);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            Tab tab = TabbedUtils.getParentTab(component);
            if (tab != null && tab.getTabbedPanel() != null && tab.getParent() != null) {
                int n;
                int n2;
                int n3;
                int n4;
                Direction direction = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
                TabLineBorder.this.initialize(tab);
                if (direction == Direction.UP) {
                    n4 = TabLineBorder.this.drawTopLine ? 1 : 0;
                    n3 = 1;
                    n2 = 0;
                    n = 1;
                } else if (direction == Direction.LEFT) {
                    n4 = 1;
                    n3 = TabLineBorder.this.drawTopLine ? 1 : 0;
                    n2 = 1;
                    n = 0;
                } else if (direction == Direction.DOWN) {
                    n4 = 0;
                    n3 = 1;
                    n2 = TabLineBorder.this.drawTopLine ? 1 : 0;
                    n = 1;
                } else {
                    n4 = 1;
                    n3 = 0;
                    n2 = 1;
                    n = TabLineBorder.this.drawTopLine ? 1 : 0;
                }
                return new Insets(n4, n3, n2, n);
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        private void paintUpBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
            graphics.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
            if (TabLineBorder.this.drawTopLine) {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
            if (TabLineBorder.this.drawBottomLine) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        }

        private void paintLeftBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
            graphics.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
            if (TabLineBorder.this.drawTopLine) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
        }

        private void paintDownBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
            graphics.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
            if (TabLineBorder.this.drawTopLine) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                graphics.drawLine(n, n2, n + n3, n2);
            }
        }

        private void paintRightBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
            graphics.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
            if (TabLineBorder.this.drawTopLine) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
        }
    }
}

