/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.layout.LayoutUtil;

public class StackableLayout
implements LayoutManager2 {
    private Container container;
    private Component component;
    private boolean autoShowFirstComponent = true;
    private boolean useSelectedComponentSize;

    public StackableLayout(Container container) {
        this.container = container;
    }

    public boolean usesSelectedComponentSize() {
        return this.useSelectedComponentSize;
    }

    public boolean isAutoShowFirstComponent() {
        return this.autoShowFirstComponent;
    }

    public void setAutoShowFirstComponent(boolean bl) {
        this.autoShowFirstComponent = bl;
    }

    public void setUseSelectedComponentSize(boolean bl) {
        if (this.useSelectedComponentSize != bl) {
            this.useSelectedComponentSize = bl;
            ComponentUtil.validate(this.container);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return LayoutUtil.add(LayoutUtil.getMinMaximumSize(container.getComponents()), container.getInsets());
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public void addLayoutComponent(Component component, Object object) {
        component.setVisible(this.autoShowFirstComponent && component.getParent().getComponentCount() == 1);
        if (component.isVisible()) {
            this.component = component;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.component) {
            this.component = null;
        }
        component.setVisible(true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return LayoutUtil.add(this.useSelectedComponentSize ? (this.component == null ? new Dimension(0, 0) : this.component.getPreferredSize()) : LayoutUtil.getMaxPreferredSize(container.getComponents()), container.getInsets());
    }

    public Dimension minimumLayoutSize(Container container) {
        return LayoutUtil.add(LayoutUtil.getMaxMinimumSize(container.getComponents()), container.getInsets());
    }

    public void layoutContainer(Container container) {
        Component[] componentArray = container.getComponents();
        Insets insets = container.getInsets();
        Dimension dimension = LayoutUtil.getInteriorSize(container);
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setBounds(insets.left, insets.top, dimension.width, dimension.height);
        }
    }

    public Component getVisibleComponent() {
        return this.component;
    }

    public void showComponent(Component component) {
        boolean bl;
        Component component2 = this.component;
        if (component2 == component) {
            return;
        }
        this.component = component;
        boolean bl2 = bl = component2 != null && LayoutUtil.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), component2);
        if (component2 != null) {
            component2.setVisible(false);
        }
        if (this.component != null) {
            this.component.setVisible(true);
            if (bl) {
                ComponentUtil.smartRequestFocus(this.component);
            }
        }
    }
}

