/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.MaximizeIcon;

public final class MaximizeWithAbortWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final MaximizeWithAbortWindowAction INSTANCE = new MaximizeWithAbortWindowAction();
    private static final Icon icon = new MaximizeIcon(10);

    private MaximizeWithAbortWindowAction() {
    }

    public Icon getIcon() {
        return icon;
    }

    public String getName() {
        return "Maximize";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        if (!dockingWindow.isMaximizable()) {
            return false;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        return tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable();
    }

    public void perform(DockingWindow dockingWindow) {
        try {
            TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
            if (tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable()) {
                tabWindow.maximizeWithAbort();
            }
        }
        catch (OperationAbortedException operationAbortedException) {
            // empty catch block
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

