\name{competitive.test}
\alias{competitive.test}
\alias{competitive.test}
\docType{package}
\title{
competitive.test: combine a vector of correlated p-values

}
\description{
In this test, we are interested to test whether pvalue is more significant than randomly selected p-values.                                     

}
\details{
\tabular{ll}{
Package: \tab CombinePValue\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-10-29\cr
License: \tab GPL-3 \cr
}

Parameters: 

Pvalue: this is a vector. For instance, pvalue=c(0.01,0.04,0.06,0.15,0.17).

Weight : This is weight for p-values. Weight should be positive and weight is a vector with the same length as pvalue. For instance, weight=c(2,4,5,2,3).

If you do not have weight for p-values, simply set weight = NA. Default sets weight=2 for each p-value. This equals to Fisher's method with correlation. Traditional Fisher's method is based on independent assumptions. In this code, all tests (including Fisher's method), take correlations into account.

p_random: this is p-value matrix by randomly selecting 100000 vectors of pvalues. Put randomly selected pvalue vectors in the columns of p_random.

}
\author{
Hongying Dai

Maintainer: Hongying Dai <hdai@cmh.edu>

}
\references{
Citation:  Dai et al. A Modified Generalized Fisher Method for Combining Probabilities from Dependent Tests. Frontiers in Genetics. 2014, 20
}

\keyword{ package }
\seealso{
d.web.umkc.edu/hdai

CombinePValue

selfcontained.test

}
\examples{
#Compare Pvalue vs randomly selected p values in columns of p_random.

b<-matrix(c(0.12,0.06,0.07,0.71,0.02,0.09,0.41,0.01,0.10,0.32,0.14,0.37,0.001,0.009,0.013),nrow=3) 
competitive.test(Pvalue=c(0.01,0.04,0.06),Weight=c(2,5,1),p_random=b) 

}
