# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Utility function to define risk groups
#'
#' \code{Make_Groups} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups <- function(ntime, df_m, RiskFail, RiskPairs, tu, nthreads) {
    invisible(.Call(`_Colossus_Make_Groups`, ntime, df_m, RiskFail, RiskPairs, tu, nthreads))
}

#' Utility function to define risk groups with competing risks
#'
#' \code{Make_Groups_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds rows with event = 2 past the event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_CR <- function(ntime, df_m, RiskFail, RiskPairs, tu, cens_weight, nthreads) {
    invisible(.Call(`_Colossus_Make_Groups_CR`, ntime, df_m, RiskFail, RiskPairs, tu, cens_weight, nthreads))
}

#' Utility function to define risk groups with Strata
#'
#' \code{Make_Groups_Strata} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_Strata <- function(ntime, df_m, RiskFail, RiskPairs_Strata, tu, nthreads, Strata_vals) {
    invisible(.Call(`_Colossus_Make_Groups_Strata`, ntime, df_m, RiskFail, RiskPairs_Strata, tu, nthreads, Strata_vals))
}

#' Utility function to define risk groups with Strata and competing risks
#'
#' \code{Make_Groups_Strata_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_Strata_CR <- function(ntime, df_m, RiskFail, RiskPairs_Strata, tu, nthreads, Strata_vals, cens_weight) {
    invisible(.Call(`_Colossus_Make_Groups_Strata_CR`, ntime, df_m, RiskFail, RiskPairs_Strata, tu, nthreads, Strata_vals, cens_weight))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides`, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with gradient option
#'
#' \code{Calculate_Sides_Gradient} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Gradient <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Gradient`, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, nthreads, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_CR <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_CR`, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR_Gradient} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_CR_Gradient <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, cens_weight, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_CR_Gradient`, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, cens_weight, nthreads, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR_SINGLE} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_CR_SINGLE <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_CR_SINGLE`, RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation. but not derivatives
#'
#' \code{Calculate_Sides_Single} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Single <- function(RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, nthreads) {
    invisible(.Call(`_Colossus_Calculate_Sides_Single`, RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, nthreads))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata
#'
#' \code{Calculate_Sides_Strata} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata
#'
#' \code{Calculate_Sides_Strata_Gradient} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata_Gradient <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata_Gradient`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata and without derivative
#'
#' \code{Calculate_Sides_Strata_Single} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group but not derivatives
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata_Single <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata_Single`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata and competing risks
#'
#' \code{Calculate_Sides_Strata_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata_CR <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata_CR`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata and competing risks
#'
#' \code{Calculate_Sides_Strata_CR_Gradient} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata_CR_Gradient <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, cens_weight, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata_CR_Gradient`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rls1, Rls2, Lls1, Lls2, cens_weight, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata and without derivative and with competing risks
#'
#' \code{Calculate_Sides_Strata_Single_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group but not derivatives but with competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Strata_Single_CR <- function(RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_Strata_Single_CR`, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, Strata_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives
#'
#' \code{Calc_LogLik} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and first derivatives
#'
#' \code{Calc_LogLik_Gradient} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Gradient <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, Rls1, Rls2, Lls1, Lls2, Ll, Lld, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Gradient`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, Rls1, Rls2, Lls1, Lls2, Ll, Lld, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives, basic model
#'
#' \code{Calc_LogLik_Basic} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Basic <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Basic`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with linear ERR simplification
#'
#' \code{Calc_LogLik_Linear_ERR} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Linear_ERR <- function(tform, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Linear_ERR`, tform, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata and Linear ERR simplification
#'
#' \code{Calc_LogLik_Strata_Linear_ERR} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Strata_Linear_ERR <- function(tform, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Strata_Linear_ERR`, tform, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood
#'
#' \code{Calc_LogLik_Single} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Single <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, Ll, ties_method) {
    invisible(.Call(`_Colossus_Calc_LogLik_Single`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rls1, Lls1, Ll, ties_method))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata
#'
#' \code{Calc_LogLik_Strata} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Strata <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Strata`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata
#'
#' \code{Calc_LogLik_Strata_Gradient} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Strata_Gradient <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, Rls1, Rls2, Lls1, Lls2, Ll, Lld, ties_method, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Strata_Gradient`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, Rls1, Rls2, Lls1, Lls2, Ll, Lld, ties_method, Strata_vals, KeepConstant))
}

#' Utility function to calculate just Cox Log-Likelihood with Strata
#'
#' \code{Calc_LogLik_Strata_SINGLE} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time and strata
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Strata_SINGLE <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, Ll, ties_method, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Strata_SINGLE`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rls1, Lls1, Ll, ties_method, Strata_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata, basic model
#'
#' \code{Calc_LogLik_Strata_BASIC} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time, basic model
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Strata_BASIC <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Strata_BASIC`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, ties_method, Strata_vals, KeepConstant))
}

#' Utility function to calculate poisson log-likelihood and derivatives
#'
#' \code{Poisson_LogLik} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Poisson_LogLik <- function(nthreads, totalnum, PyrC, R, Rd, Rdd, RdR, RddR, Ll, Lld, Lldd, KeepConstant) {
    invisible(.Call(`_Colossus_Poisson_LogLik`, nthreads, totalnum, PyrC, R, Rd, Rdd, RdR, RddR, Ll, Lld, Lldd, KeepConstant))
}

#' Utility function to calculate poisson log-likelihood and derivatives
#'
#' \code{Poisson_LogLik_Gradient} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Poisson_LogLik_Gradient <- function(nthreads, totalnum, PyrC, R, Rd, RdR, Ll, Lld, KeepConstant) {
    invisible(.Call(`_Colossus_Poisson_LogLik_Gradient`, nthreads, totalnum, PyrC, R, Rd, RdR, Ll, Lld, KeepConstant))
}

#' Utility function to calculate poisson log-likelihood
#'
#' \code{Poisson_LogLik_Single} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Poisson_LogLik_Single <- function(nthreads, totalnum, PyrC, R, Ll) {
    invisible(.Call(`_Colossus_Poisson_LogLik_Single`, nthreads, totalnum, PyrC, R, Ll))
}

#' Utility function to perform null model equivalent of Calculate_Sides
#'
#' \code{Calculate_Null_Sides} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Null_Sides <- function(RiskFail, RiskPairs, ntime, R, Rls1, Lls1, nthreads) {
    invisible(.Call(`_Colossus_Calculate_Null_Sides`, RiskFail, RiskPairs, ntime, R, Rls1, Lls1, nthreads))
}

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_Null_LogLik <- function(nthreads, RiskFail, RiskPairs, ntime, R, Rls1, Lls1, Ll, ties_method) {
    invisible(.Call(`_Colossus_Calc_Null_LogLik`, nthreads, RiskFail, RiskPairs, ntime, R, Rls1, Lls1, Ll, ties_method))
}

#' Utility function to perform null model equivalent of Calculate_Sides with strata
#'
#' \code{Calculate_Null_Sides_Strata} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Null_Sides_Strata <- function(RiskFail, RiskPairs_Strata, ntime, R, Rls1, Lls1, Strata_vals, nthreads) {
    invisible(.Call(`_Colossus_Calculate_Null_Sides_Strata`, RiskFail, RiskPairs_Strata, ntime, R, Rls1, Lls1, Strata_vals, nthreads))
}

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik_Strata} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_Null_LogLik_Strata <- function(nthreads, RiskFail, RiskPairs_Strata, ntime, R, Rls1, Lls1, Strata_vals, Ll, ties_method) {
    invisible(.Call(`_Colossus_Calc_Null_LogLik_Strata`, nthreads, RiskFail, RiskPairs_Strata, ntime, R, Rls1, Lls1, Strata_vals, Ll, ties_method))
}

#' checks if the model is viable
#'
#' \code{Check_Risk} Calculates risks and checks for negative values
#'
#' @inheritParams CPP_template
#'
#' @return True for viable point, False for negative error
#' @noRd
#'
Check_Risk <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, verbose, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term) {
    .Call(`_Colossus_Check_Risk`, term_n, tform, a_n, x_all, dfc, fir, modelform, verbose, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term)
}

#' Primary Cox PH regression with multiple starting points and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus <- function(term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, optim_para, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus`, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, optim_para, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary poisson regression with multiple starting points and optional combinations of stratification and no derivative calculation.
#'
#' \code{LogLik_Pois_Omnibus} Performs the calls to calculation functions, Structures the poisson regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Pois_Omnibus <- function(PyrC, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, optim_para, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, double_step, change_all, verbose, KeepConstant, term_tot, nthreads, dfs, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Pois_Omnibus`, PyrC, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, optim_para, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, double_step, change_all, verbose, KeepConstant, term_tot, nthreads, dfs, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus_Log_Bound <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus_Log_Bound`, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus_Log_Bound_Search <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus_Log_Bound_Search`, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Poisson_Omnibus_Log_Bound <- function(PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Poisson_Omnibus_Log_Bound`, PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Poisson_Omnibus_Log_Bound_Search <- function(PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Poisson_Omnibus_Log_Bound_Search`, PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Cox PH regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Multidose_Omnibus_Serial} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, standard error, and convergence for each realization
#' @noRd
#'
LogLik_Cox_PH_Multidose_Omnibus_Serial <- function(term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, optim_para, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Cox_PH_Multidose_Omnibus_Serial`, term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, optim_para, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary Cox PH regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Multidose_Omnibus_Integrated} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: standard cox outputs for the integrated solution
#' @noRd
#'
LogLik_Cox_PH_Multidose_Omnibus_Integrated <- function(term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, optim_para, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Cox_PH_Multidose_Omnibus_Integrated`, term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, optim_para, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus_Log_Bound_CurveSearch <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, lr, optim_para, maxiter, double_step, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, step_size) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus_Log_Bound_CurveSearch`, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, optim_para, maxiter, double_step, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, step_size)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Poisson_Omnibus_Log_Bound_CurveSearch <- function(PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, optim_para, maxiter, doublestep, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, step_size) {
    .Call(`_Colossus_LogLik_Poisson_Omnibus_Log_Bound_CurveSearch`, PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, optim_para, maxiter, doublestep, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, KeepConstant, term_tot, nthreads, model_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, step_size)
}

#' Utility function to refresh risk and subterm matrices for Cox Omnibus function
#'
#' \code{Cox_Refresh_R_TERM} Called to update matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place
#' @noRd
#'
Cox_Refresh_R_TERM <- function(totalnum, reqrdnum, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, model_bool) {
    invisible(.Call(`_Colossus_Cox_Refresh_R_TERM`, totalnum, reqrdnum, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, model_bool))
}

#' Utility function to refresh side matrices for Cox Omnibus
#'
#' \code{Cox_Refresh_R_SIDES} Called to fresh repeated sum calculation matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Refresh_R_SIDES <- function(reqrdnum, ntime, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Strata_vals, model_bool) {
    invisible(.Call(`_Colossus_Cox_Refresh_R_SIDES`, reqrdnum, ntime, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Strata_vals, model_bool))
}

#' Utility function to perform calculation of terms and risks for Cox Omnibus
#'
#' \code{Cox_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Term_Risk_Calc <- function(modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, verbose, model_bool, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Cox_Term_Risk_Calc`, modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, verbose, model_bool, gmix_theta, gmix_term))
}

#' Utility function to perform calculation of Repeated Calculations and Log-Likelihood for Cox Omnibus
#'
#' \code{Cox_Side_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Side_LL_Calc <- function(reqrdnum, ntime, tform, RiskFail, RiskPairs, RiskPairs_Strata, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, Strata_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, ties_method, verbose, model_bool, iter_stop) {
    invisible(.Call(`_Colossus_Cox_Side_LL_Calc`, reqrdnum, ntime, tform, RiskFail, RiskPairs, RiskPairs_Strata, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, Strata_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, ties_method, verbose, model_bool, iter_stop))
}

#' Utility function to print likelihood and derivatives
#'
#' \code{Print_LL} Called to print likelihood and derivatives
#' @inheritParams CPP_template
#'
#' @return Noting
#' @noRd
#'
Print_LL <- function(reqrdnum, totalnum, beta_0, Ll, Lld, Lldd, verbose, model_bool) {
    invisible(.Call(`_Colossus_Print_LL`, reqrdnum, totalnum, beta_0, Ll, Lld, Lldd, verbose, model_bool))
}

#' Utility function to perform calculation of terms and risks for Poisson Omnibus
#'
#' \code{Pois_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Pois_Term_Risk_Calc <- function(modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, s_weights, nthreads, KeepConstant, verbose, model_bool, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Pois_Term_Risk_Calc`, modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, s_weights, nthreads, KeepConstant, verbose, model_bool, gmix_theta, gmix_term))
}

#' Utility function to perform calculation of Log-Likelihood and Deviation for Poisson Omnibus
#'
#' \code{Pois_Dev_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#' @param dev_temp temporary storage for deviation calculation
#' @param dev model deviation
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Pois_Dev_LL_Calc <- function(reqrdnum, totalnum, fir, R, Rd, Rdd, beta_0, RdR, RddR, Ll, Lld, Lldd, PyrC, dev_temp, nthreads, KeepConstant, verbose, model_bool, iter_stop, dev) {
    invisible(.Call(`_Colossus_Pois_Dev_LL_Calc`, reqrdnum, totalnum, fir, R, Rd, Rdd, beta_0, RdR, RddR, Ll, Lld, Lldd, PyrC, dev_temp, nthreads, KeepConstant, verbose, model_bool, iter_stop, dev))
}

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
Cox_Pois_Check_Continue <- function(model_bool, beta_0, beta_best, beta_c, cens_weight, change_all, dbeta, dev, dev_temp, fir, halfmax, halves, ind0, iter_stop, KeepConstant, Ll, Ll_abs_best, Lld, Lldd, Lls1, Lls2, Lls3, Lstar, nthreads, ntime, PyrC, R, Rd, Rdd, RddR, RdR, reqrdnum, tform, RiskFail, RiskPairs, RiskPairs_Strata, Rls1, Rls2, Rls3, Strata_vals, term_n, ties_method, totalnum, TTerm, verbose) {
    invisible(.Call(`_Colossus_Cox_Pois_Check_Continue`, model_bool, beta_0, beta_best, beta_c, cens_weight, change_all, dbeta, dev, dev_temp, fir, halfmax, halves, ind0, iter_stop, KeepConstant, Ll, Ll_abs_best, Lld, Lldd, Lls1, Lls2, Lls3, Lstar, nthreads, ntime, PyrC, R, Rd, Rdd, RddR, RdR, reqrdnum, tform, RiskFail, RiskPairs, RiskPairs_Strata, Rls1, Rls2, Rls3, Strata_vals, term_n, ties_method, totalnum, TTerm, verbose))
}

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
Cox_Pois_Log_Loop <- function(abs_max, model_bool, beta_0, beta_a, beta_c, bound_val, dbeta, df0, dfc, dint, Dose, dose_abs_max, dslp, fir, gmix_term, gmix_theta, half_check, halfmax, KeepConstant, limit_hit, lr, modelform, nonDose, nonDose_LIN, nonDose_LOGLIN, nonDose_PLIN, nthreads, R, Rd, Rdd, RddR, RdR, s_weights, T0, Td0, Tdd0, Te, term_n, term_tot, tform, totalnum, TTerm, verbose) {
    invisible(.Call(`_Colossus_Cox_Pois_Log_Loop`, abs_max, model_bool, beta_0, beta_a, beta_c, bound_val, dbeta, df0, dfc, dint, Dose, dose_abs_max, dslp, fir, gmix_term, gmix_theta, half_check, halfmax, KeepConstant, limit_hit, lr, modelform, nonDose, nonDose_LIN, nonDose_LOGLIN, nonDose_PLIN, nthreads, R, Rd, Rdd, RddR, RdR, s_weights, T0, Td0, Tdd0, Te, term_n, term_tot, tform, totalnum, TTerm, verbose))
}

#' Run a complete regression for a cox model
#'
#' \code{Cox_Full_Run} Called to perform one full regression
#' @inheritParams CPP_template
#'
#' @return Updates everything in place
#' @noRd
#'
Cox_Full_Run <- function(reqrdnum, ntime, tform, RiskFail, RiskPairs, RiskPairs_Strata, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, Strata_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, ties_method, verbose, model_bool, iter_stop, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, modelform, gmix_theta, gmix_term, convgd, der_iden, lr, optim_para, maxiter, double_step, change_all, Lin_Sys, Lin_Res, term_n, dfc, halfmax, epsilon, deriv_epsilon) {
    .Call(`_Colossus_Cox_Full_Run`, reqrdnum, ntime, tform, RiskFail, RiskPairs, RiskPairs_Strata, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, Strata_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, ties_method, verbose, model_bool, iter_stop, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, modelform, gmix_theta, gmix_term, convgd, der_iden, lr, optim_para, maxiter, double_step, change_all, Lin_Sys, Lin_Res, term_n, dfc, halfmax, epsilon, deriv_epsilon)
}

#' Run a complete regression for a cox model
#'
#' \code{Pois_Full_Run} Called to perform one full regression
#' @inheritParams CPP_template
#'
#' @return Updates everything in place
#' @noRd
#'
Pois_Full_Run <- function(PyrC, reqrdnum, tform, totalnum, fir, R, Rd, Rdd, s_weights, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, verbose, model_bool, iter_stop, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, modelform, gmix_theta, gmix_term, convgd, der_iden, lr, optim_para, maxiter, double_step, change_all, Lin_Sys, Lin_Res, term_n, dfc, halfmax, epsilon, deriv_epsilon) {
    .Call(`_Colossus_Pois_Full_Run`, PyrC, reqrdnum, tform, totalnum, fir, R, Rd, Rdd, s_weights, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, KeepConstant, verbose, model_bool, iter_stop, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, modelform, gmix_theta, gmix_term, convgd, der_iden, lr, optim_para, maxiter, double_step, change_all, Lin_Sys, Lin_Res, term_n, dfc, halfmax, epsilon, deriv_epsilon)
}

#' Utility function to calculate Information Matrix, from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox} Called to update information matrix
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
Expected_Inform_Matrix_Cox <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, InMa, KeepConstant) {
    invisible(.Call(`_Colossus_Expected_Inform_Matrix_Cox`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, InMa, KeepConstant))
}

#' Utility function to calculate Information Matrix with strata, from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_Strata} Called to update information matrix with strata
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
Expected_Inform_Matrix_Cox_Strata <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, InMa, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Expected_Inform_Matrix_Cox_Strata`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, InMa, Strata_vals, KeepConstant))
}

#' Utility function to calculate Information Matrix with competing risks, adapted from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_CR} Called to update information matrix with competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
Expected_Inform_Matrix_Cox_CR <- function(nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, cens_weight, InMa, KeepConstant) {
    invisible(.Call(`_Colossus_Expected_Inform_Matrix_Cox_CR`, nthreads, RiskFail, RiskPairs, totalnum, ntime, R, Rd, RdR, cens_weight, InMa, KeepConstant))
}

#' Utility function to calculate Information Matrix with strata and competing risks, adapted from from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_Strata_CR} Called to update information matrix with strata and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
Expected_Inform_Matrix_Cox_Strata_CR <- function(nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, cens_weight, InMa, Strata_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Expected_Inform_Matrix_Cox_Strata_CR`, nthreads, RiskFail, RiskPairs_Strata, totalnum, ntime, R, Rd, RdR, cens_weight, InMa, Strata_vals, KeepConstant))
}

#' Utility function to calculate poisson expected information matrix
#'
#' \code{Expected_Inform_Matrix_Poisson} Called to update information matrix
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Expected_Inform_Matrix_Poisson <- function(nthreads, totalnum, PyrC, R, Rd, RdR, InMa, KeepConstant) {
    invisible(.Call(`_Colossus_Expected_Inform_Matrix_Poisson`, nthreads, totalnum, PyrC, R, Rd, RdR, InMa, KeepConstant))
}

#' Primary Cox PH baseline hazard function with stratification
#'
#' \code{PLOT_SURV_Strata} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
PLOT_SURV_Strata <- function(reqrdnum, R, Rd, a_er, df_groups, tu, Strata_vals, verbose, nthreads) {
    .Call(`_Colossus_PLOT_SURV_Strata`, reqrdnum, R, Rd, a_er, df_groups, tu, Strata_vals, verbose, nthreads)
}

#' Primary Cox PH baseline hazard function
#'
#' \code{PLOT_SURV} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
PLOT_SURV <- function(reqrdnum, R, Rd, a_er, df_groups, tu, verbose, nthreads) {
    .Call(`_Colossus_PLOT_SURV`, reqrdnum, R, Rd, a_er, df_groups, tu, verbose, nthreads)
}

#' Primary Cox PH schoenfeld residual function
#'
#' \code{Schoenfeld_Calc} Performs the calls to calculation functions, Uses calculated risks and risk groups to calculate the residuals, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: scaled schoenfeld residuals
#' @noRd
#'
Schoenfeld_Calc <- function(ntime, totalnum, beta_0, df0, R, Lldd_inv, RiskFail, RiskPairs, dfc, verbose, KeepConstant, nthreads) {
    .Call(`_Colossus_Schoenfeld_Calc`, ntime, totalnum, beta_0, df0, R, Lldd_inv, RiskFail, RiskPairs, dfc, verbose, KeepConstant, nthreads)
}

#' Primary plotting function.
#'
#' \code{Plot_Omnibus} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Plot_Omnibus <- function(term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, uniq_v, model_bool, Surv_bool, Risk_bool, Schoenfeld_bool, Risk_Sub_bool, gmix_theta, gmix_term) {
    .Call(`_Colossus_Plot_Omnibus`, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, df_groups, tu, verbose, KeepConstant, term_tot, ties_method, nthreads, Strata_vals, cens_weight, uniq_v, model_bool, Surv_bool, Risk_bool, Schoenfeld_bool, Risk_Sub_bool, gmix_theta, gmix_term)
}

#' Splits events into background and excess for a poisson regression
#'
#' \code{Assign_Events_Pois} Calculates proportion of events due to background and excess
#'
#' @inheritParams CPP_template
#'
#' @return returns proportion of events due to background and excess for each term
#' @noRd
#'
Assign_Events_Pois <- function(term_n, tform, a_n, x_all, dfc, PyrC, dfs, fir, modelform, verbose, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term, model_bool) {
    .Call(`_Colossus_Assign_Events_Pois`, term_n, tform, a_n, x_all, dfc, PyrC, dfs, fir, modelform, verbose, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term, model_bool)
}

#' Primary plotting function.
#'
#' \code{Poisson_Residuals} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Poisson_Residuals <- function(PyrC, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, verbose, KeepConstant, term_tot, nthreads, dfs, model_bool, gmix_theta, gmix_term, Pearson_bool, Deviance_bool) {
    .Call(`_Colossus_Poisson_Residuals`, PyrC, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, verbose, KeepConstant, term_tot, nthreads, dfs, model_bool, gmix_theta, gmix_term, Pearson_bool, Deviance_bool)
}

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_transition <- function(term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_Omnibus_transition`, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson omnibus regression function
#'
#' \code{pois_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_transition <- function(dfe, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_pois_Omnibus_transition`, dfe, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the event assignment omnibus function
#'
#' \code{Assigned_Event_transition} Called directly from R, Defines the control variables and calls the assigning functions
#' @inheritParams CPP_template
#'
#' @return list of assigned/predicted background/excess events
#' @noRd
#'
Assigned_Event_Poisson_transition <- function(dfe, df0, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, model_control) {
    .Call(`_Colossus_Assigned_Event_Poisson_transition`, dfe, df0, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, model_control)
}

#' Interface between R code and the plotting omnibus function
#'
#' \code{Plot_Omnibus_transition} Called directly from R, Defines the control variables and calls the plotting functions
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Plot_Omnibus_transition <- function(term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control) {
    .Call(`_Colossus_Plot_Omnibus_transition`, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control)
}

#' Interface between R code and the Cox PH omnibus bounds regression function
#'
#' \code{cox_ph_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_Bounds_transition <- function(term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_Omnibus_Bounds_transition`, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the Cox PH omnibus bounds regression function
#'
#' \code{cox_ph_Omnibus_CurveSearch_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_CurveSearch_transition <- function(term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_Omnibus_CurveSearch_transition`, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson omnibus bounds regression function
#'
#' \code{pois_Omnibus_CurveSearch_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_CurveSearch_transition <- function(dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_pois_Omnibus_CurveSearch_transition`, dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson omnibus bounds regression function
#'
#' \code{pois_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_Bounds_transition <- function(dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_pois_Omnibus_Bounds_transition`, dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson residual calculation function
#'
#' \code{pois_Residual_transition} Called directly from R, Defines the control variables and calls the calculation function
#' @inheritParams CPP_template
#'
#' @return Poisson_Residuals output : list of residuals and sum
#' @noRd
#'
pois_Residual_transition <- function(dfe, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control) {
    .Call(`_Colossus_pois_Residual_transition`, dfe, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control)
}

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_multidose_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_multidose_Omnibus_transition <- function(term_n, tform, a_n, dose_cols, dose_index, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_multidose_Omnibus_transition`, term_n, tform, a_n, dose_cols, dose_index, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, Strata_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Generates csv file with time-dependent columns
#'
#' \code{Write_Time_Dep} Called directly from R, Defines a new matrix which interpolates time-dependent values on a grid
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Write_Time_Dep <- function(df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads) {
    invisible(.Call(`_Colossus_Write_Time_Dep`, df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads))
}

#' Generates factored columns in parallel
#'
#' \code{Gen_Fac_Par} Called directly from R, returns a matrix with factored columns
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Gen_Fac_Par <- function(df0, vals, cols, nthreads) {
    .Call(`_Colossus_Gen_Fac_Par`, df0, vals, cols, nthreads)
}

#' Interface between R code and the risk check
#'
#' \code{cox_ph_transition_single} Called directly from R, Defines the control variables and calls the function which only calculates the log-likelihood
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
risk_check_transition <- function(term_n, tform, a_n, dfc, x_all, fir, modelform, Control, model_control, KeepConstant, term_tot) {
    .Call(`_Colossus_risk_check_transition`, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, model_control, KeepConstant, term_tot)
}

#' Generates weightings for stratified poisson regression
#'
#' \code{Gen_Strat_Weight} Called from within c++, assigns vector of weights
#' @inheritParams CPP_template
#'
#' @return assigns weight in place and returns nothing
#' @noRd
#'
Gen_Strat_Weight <- function(modelform, dfs, PyrC, s_weights, nthreads, tform, term_n, term_tot) {
    invisible(.Call(`_Colossus_Gen_Strat_Weight`, modelform, dfs, PyrC, s_weights, nthreads, tform, term_n, term_tot))
}

#' Checks the OMP flag
#'
#' \code{OMP_Check} Called directly from R, checks the omp flag and returns if omp is enabled
#'
#' @return boolean: True for OMP allowed
#'
OMP_Check <- function() {
    .Call(`_Colossus_OMP_Check`)
}

#' Utility function to keep intercept parameters within the range of possible values
#'
#' \code{Intercept_Bound} Called to update the parameter list in the event that intercepts leave the bounds of possible values
#' @inheritParams CPP_template
#'
#' @return Updates vector in place: parameter vector
#' @noRd
#'
Intercept_Bound <- function(nthreads, totalnum, beta_0, dbeta, dfc, df0, KeepConstant, tform) {
    invisible(.Call(`_Colossus_Intercept_Bound`, nthreads, totalnum, beta_0, dbeta, dfc, df0, KeepConstant, tform))
}

#' Utility function to calculate the change to make each iteration, applying linear constraints
#'
#' \code{Calc_Change_Cons} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations with a system of constraints
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_Cons <- function(Lin_Sys, Lin_Res, beta_0, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_Change_Cons`, Lin_Sys, Lin_Res, beta_0, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant))
}

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change <- function(double_step, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, tform, dint, dslp, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_Change`, double_step, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, tform, dint, dslp, KeepConstant))
}

#' Utility function to calculate the change to make each iteration with gradient step
#'
#' \code{Calc_Change_Gradient} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies gradient normalization and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_Gradient <- function(nthreads, model_bool, totalnum, optim_para, iteration, abs_max, Lld, m_g_store, v_beta_store, dbeta, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_Change_Gradient`, nthreads, model_bool, totalnum, optim_para, iteration, abs_max, Lld, m_g_store, v_beta_store, dbeta, KeepConstant))
}

#' Utility function to calculate the change to make each iteration, with basic model
#'
#' \code{Calc_Change_Basic} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_Basic <- function(double_step, nthreads, totalnum, der_iden, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_Change_Basic`, double_step, nthreads, totalnum, der_iden, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, KeepConstant))
}

#' Utility function to calculate steps for a likelihood based bound
#'
#' \code{Log_Bound} Called to perform likelihood bound steps
#' @inheritParams CPP_template
#' @param Lstar likelihood goal
#' @param L0 current likelihood
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Log_Bound <- function(deriv_max, Lldd_mat, Lld_vec, Lstar, qchi, L0, para_number, nthreads, totalnum, reqrdnum, KeepConstant, term_tot, step, dbeta, beta_0, upper, trouble, verbose, mult) {
    invisible(.Call(`_Colossus_Log_Bound`, deriv_max, Lldd_mat, Lld_vec, Lstar, qchi, L0, para_number, nthreads, totalnum, reqrdnum, KeepConstant, term_tot, step, dbeta, beta_0, upper, trouble, verbose, mult))
}

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change_trouble} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_trouble <- function(para_number, nthreads, totalnum, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant_trouble) {
    invisible(.Call(`_Colossus_Calc_Change_trouble`, para_number, nthreads, totalnum, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant_trouble))
}

#' Utility function to calculate the term and subterm values
#'
#' \code{Make_subterms} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms <- function(totalnum, term_n, tform, dfc, fir, T0, Td0, Tdd0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, dint, dslp, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms`, totalnum, term_n, tform, dfc, fir, T0, Td0, Tdd0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, dint, dslp, nthreads, KeepConstant))
}

#' Utility function to calculate the term and subterm values with gradient method
#'
#' \code{Make_subterms_Gradient} Called to update term matrices, Uses lists of term numbers and types to apply formulas, gradient method
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Gradient <- function(totalnum, term_n, tform, dfc, fir, T0, Td0, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms_Gradient`, totalnum, term_n, tform, dfc, fir, T0, Td0, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant))
}

#' Utility function to calculate the term and subterm values, but not derivatives
#'
#' \code{Make_subterms_Single} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Single <- function(totalnum, term_n, tform, dfc, fir, T0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms_Single`, totalnum, term_n, tform, dfc, fir, T0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant))
}

#' Utility function to calculate the term and subterm values with the basic model
#'
#' \code{Make_subterms_Basic} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Basic <- function(totalnum, dfc, T0, beta_0, df0, nthreads) {
    invisible(.Call(`_Colossus_Make_subterms_Basic`, totalnum, dfc, T0, beta_0, df0, nthreads))
}

#' Utility function to calculate the term and subterm values
#'
#' \code{Make_subterms_Linear_ERR} Called to update subterms for Linear ERR simplification
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Linear_ERR <- function(totalnum, tform, dfc, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms_Linear_ERR`, totalnum, tform, dfc, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, KeepConstant))
}

#' Utility function to calculate the risk and risk ratios
#'
#' \code{Make_Risks} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks <- function(modelform, tform, term_n, totalnum, fir, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks`, modelform, tform, term_n, totalnum, fir, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk and risk ratios for gradient method
#'
#' \code{Make_Risks_Gradient} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas for gradient method
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Gradient <- function(modelform, tform, term_n, totalnum, fir, T0, Td0, Te, R, Rd, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_Risks_Gradient`, modelform, tform, term_n, totalnum, fir, T0, Td0, Te, R, Rd, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, nthreads, KeepConstant))
}

#' Utility function to calculate the risk and risk ratios with a weighting applied
#'
#' \code{Make_Risks_Weighted} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Weighted <- function(modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Weighted`, modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk and risk ratios with a weighting applied and gradient method
#'
#' \code{Make_Risks_Weighted_Gradient} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Weighted_Gradient <- function(modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Te, R, Rd, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_Risks_Weighted_Gradient`, modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Te, R, Rd, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, nthreads, KeepConstant))
}

#' Utility function to calculate the risk with a weighting applied and no derivatives calculated
#'
#' \code{Make_Risks_Weighted_Single} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Weighted_Single <- function(modelform, tform, term_n, totalnum, fir, s_weights, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Weighted_Single`, modelform, tform, term_n, totalnum, fir, s_weights, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk, but not derivatives
#'
#' \code{Make_Risks_Single} Called to update risk matrices, Splits into cases based on model form
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Single <- function(modelform, tform, term_n, totalnum, fir, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Single`, modelform, tform, term_n, totalnum, fir, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk and risk ratios for the basic model
#'
#' \code{Make_Risks_Basic} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Basic <- function(totalnum, T0, R, Rd, Rdd, RdR, nthreads, df0, dfc, KeepConstant) {
    invisible(.Call(`_Colossus_Make_Risks_Basic`, totalnum, T0, R, Rd, Rdd, RdR, nthreads, df0, dfc, KeepConstant))
}

#' Utility function to calculate the risk and risk ratios
#'
#' \code{Make_Risks_Linear_ERR} Called to update risk matrices, uses the Linear ERR simplification
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Linear_ERR <- function(tform, dfc, df0, totalnum, R, Rd, Rdd, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant) {
    invisible(.Call(`_Colossus_Make_Risks_Linear_ERR`, tform, dfc, df0, totalnum, R, Rd, Rdd, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, KeepConstant))
}

