% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Def_modelform_fix}
\alias{Def_modelform_fix}
\title{Automatically assigns geometric-mixture values
\code{Def_model_control} checks and assigns default values}
\usage{
Def_modelform_fix(control, model_control, modelform, Term_n)
}
\arguments{
\item{control}{list of parameters controlling the convergence}

\item{model_control}{controls which alternative model options are used}

\item{modelform}{string specifying the model type}

\item{Term_n}{term numbers for each element of the model}
}
\value{
returns a filled list
}
\description{
Automatically assigns geometric-mixture values
\code{Def_model_control} checks and assigns default values
}
\examples{
library(data.table)
control <- list("Ncores"=2,'lr' = 0.75,'maxiter' = 5, 'ties'='breslow','double_step'=1)
control <- Def_Control(control)
model_control <- list("single"=TRUE)
model_control <- Def_model_control(model_control)
Term_n <- c(0,1,1)
modelform <- 'a'
val <- Def_modelform_fix(control,model_control,modelform,Term_n)
model_control <- val$model_control
modelform <- val$modelform

}
