% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colombia_departments.R
\name{get_colombia_departments}
\alias{get_colombia_departments}
\title{Get Colombia's Departments from API Colombia}
\source{
API Colombia: \url{https://api-colombia.com/api/v1/Department}
}
\usage{
get_colombia_departments()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{id}: Department identifier (integer)
  \item \code{name}: Department name (character)
  \item \code{capital}: Capital city name (character)
  \item \code{surface}: Department area in km² (integer)
  \item \code{population}: Department population (integer)
  \item \code{municipalities}: Number of municipalities (integer)
  \item \code{phone_prefix}: Phone area code (character)
  \item \code{region_id}: Geographic region identifier (integer)
}
}
\description{
Retrieves comprehensive information about all Colombian departments from the API Colombia service.
This function fetches data including department names, capitals, geographical information,
area, population, and administrative details for all 32 departments plus Bogotá D.C.
}
\details{
This function sends a GET request to the API Colombia service.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_colombia_departments()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
