% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_bedinfo.R
\docType{methods}
\name{plInfo}
\alias{plInfo}
\alias{plInfo,PlInfoC,character,logical-method}
\alias{plInfo,PlInfoC,character,missing-method}
\alias{plInfo,missing,character,logical-method}
\alias{plInfo,missing,character,missing-method}
\title{Constructor for PlInfoC class}
\usage{
plInfo(pl_info, bedstem, db_setup)

\S4method{plInfo}{PlInfoC,character,logical}(pl_info, bedstem, db_setup)

\S4method{plInfo}{PlInfoC,character,missing}(pl_info, bedstem, db_setup)

\S4method{plInfo}{missing,character,logical}(pl_info, bedstem, db_setup)

\S4method{plInfo}{missing,character,missing}(pl_info, bedstem, db_setup)
}
\arguments{
\item{pl_info}{a PlInfoC object, possibly empty.}

\item{bedstem}{path of bed file excluding extension name}

\item{db_setup}{logical. Whether to setup SQLite database for .bim, .fam and .frq files.}
}
\value{
a PlInfoC object
}
\description{
Populates an PlInfoC object from a given plink bed filename stem (i.e. exclude extension name)
}
\examples{
\dontrun{
		pl_info = plInfo(.PlInfoC(), "mmp13", db_setup = TRUE)
		isSetup(pl_info)
		bim_ff = getQuery(sqliteFilePl(pl_info), "select * from bim")
		fam_ff = getQuery(sqliteFilePl(pl_info), "select * from fam")
		frq_ff = getQuery(sqliteFilePl(pl_info), "select * from frq")
}
}
\author{
Kaiyin Zhong, Fan Liu
}

