% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anisotropyT.R
\name{anisotropyTswirl}
\alias{anisotropyTswirl}
\title{Swirl anisotropy transformation}
\usage{
anisotropyTswirl(spacepoints, x0, y0, b, alpha)
}
\arguments{
\item{spacepoints}{vector of coordinates (2 x d), where d is the number of locations/grid points}

\item{x0}{x coordinate of the center of the swirl deformation}

\item{y0}{y coordinate of the center of the swirl deformation}

\item{b}{scaling parameter controlling the swirl deformation}

\item{alpha}{rotation angle}
}
\description{
Swirl anisotropy transformation.
}
\examples{

## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

at <- anisotropyTswirl(spacepoints = coord,
                      x0 = floor(m / 2),
                      y0 = floor(m / 2),
                      b = 10,
                      alpha = 1.5 * pi)

## visualize transformed coordinate system
aux = data.frame(lon = at[ ,1], lat = at[ ,2], id1 = rep(1:m, each = m), id2 = rep(1:m, m))
ggplot(aux, aes(x = lon, y = lat)) +
geom_path(aes(group = id1)) +
geom_path(aes(group = id2)) +
geom_point(col = 2) +
theme_light()
}
\references{
Ligas, M., Banas, M., Szafarczyk, A. (2019). A method for local
approximation of a planar deformation field. Reports on Geodesy and
Geoinformatics, 108(1), 1-8, \doi{10.2478/rgg-2019-0007}

Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
