% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_train_network_relu}
\alias{cpp_train_network_relu}
\title{Function used as part of other functions}
\usage{
cpp_train_network_relu(
  x,
  y,
  c,
  testx,
  testy,
  testc,
  W1_input,
  B1_input,
  W2_input,
  B2_input,
  C2_input,
  ipw,
  lr = 0.01,
  maxepochs = 100,
  input_parameter_reg = 1e-06,
  drop_out = 0L,
  fix_baseline_risk = -1
)
}
\arguments{
\item{x}{A matrix of predictors for the training dataset of shape (nsamples, nfeatures)}

\item{y}{A vector of output values for the training data with a length similar to the number of rows of x}

\item{c}{A vector of the data to adjust the analysis for such as calendar time (training data) with the same number of rows as x.}

\item{testx}{A matrix of predictors for the test dataset of shape (nsamples, nfeatures)}

\item{testy}{A vector of output values for the test data with a length similar to the number of rows of x}

\item{testc}{A vector the data to adjust the analysis for such as calendar time (training data) with the same number of rows as x.}

\item{W1_input}{Input-hidden layer weights of shape (nfeatuers, hidden)}

\item{B1_input}{Biases for the hidden layer of shape (1, hidden)}

\item{W2_input}{Hidden-output layer weights of shape (hidden, 1)}

\item{B2_input}{Bias for the output layer (the baseline risk) af shape (1, 1)}

\item{C2_input}{Bias for the data to adjust the analysis for}

\item{ipw}{a vector of weights per observation to allow for inverse probability of censoring weighting to correct for selection bias}

\item{lr}{Initial learning rate}

\item{maxepochs}{The maximum number of epochs}

\item{input_parameter_reg}{Regularisation decreasing parameter value at each iteration for the input parameters}

\item{drop_out}{To drop connections if their weights reaches zero.}

\item{fix_baseline_risk}{To fix the baseline risk at a value.}
}
\value{
A list of class "SCL" giving the estimated matrices and performance indicators
}
\description{
Non-negative neural network
}
\author{
Andreas Rieckmann, Piotr Dworzynski, Leila Arras, Claus Ekstrøm
}
