% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedValues_EstParmFunc_FBM.R
\name{ExpectedValues_EstParmFunc_FBM}
\alias{ExpectedValues_EstParmFunc_FBM}
\title{Obtainig the value of the dirichlet parameters, the expected value and the variance.}
\usage{
ExpectedValues_EstParmFunc_FBM(
  paramEstimadosFinal,
  especie,
  E,
  EspecieMaxima,
  Tt
)
}
\arguments{
\item{paramEstimadosFinal}{The estimate parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{E}{Number of bacteria available.}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}.This bacteria is used as reference in the alr tranformation that the model does and it is placed at the denominator of the balance).}

\item{Tt}{Number of time points available.}
}
\value{
Returns a list with:

\itemize{
  \item Dirichlet.Param:  Matrix. Matrix that contains at row i the dirichlet parameter of the bacteria i at all time points.
  \item Expected.Value:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
   \item Variance.Value:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
  }
}
\description{
This function calculates the value of the dirichlet parameters, the expected value and the variance for the FBM model.
}
\details{
The regression of this model is defined by


\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{

set.seed(123)
especie=t(gtools::rdirichlet(2,c(1,1,3)))
Tt=2
E=3
tau=5
EspecieMaxima=3
Iter.EstParmFunc=5
parms11=c(0.1,0.2,0.3,0.4,0.5,0.6,tau)

ExpectedValues_EstParmFunc_FBM(parms11 , especie,E,EspecieMaxima,Tt)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
