% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.analysis.r
\name{cl.analysis}
\alias{cl.analysis}
\title{Cluster analusis}
\usage{
cl.analysis(cl.data, cl_feature = NULL, amount = NULL, cl.aggregate = "sum",
cl.meth = NULL, clust.numb = NULL, dist = "euclidean", tojson = FALSE)
}
\arguments{
\item{cl.data}{The input data}

\item{cl_feature}{The feature to be clustered (nominal variables)}

\item{amount}{The numeric variables}

\item{cl.aggregate}{Select a different aggregation in case of filtering the input data}

\item{cl.meth}{The clustering method algorithm}

\item{clust.numb}{The number of clusters}

\item{dist}{The distance metric}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
The final returns are the parameters needed for visualizing the cluster data depending on the selected algorithm and the specification parameters, 
as long as some comparison measure matrices.

\itemize{
\item cluster.method - Label of the clustering algorithm
\item raw.data - Input data
\item data.pca - The principal components to visualize the input data
\item modelparam - The results of this parameter depend of the selected clustering model
\item compare - Clustering measures}
}
\description{
Clustering Analysis for OBEU datasets.
}
\details{
There are different clustering models to be selected through an evaluation process. 
The user should define the cl_feature, cl.aggregate and amount parameters to form the structure of cluster data. 
The clustering algorithm, the number of clusters and the distance metric of the clustering model are set
to the best selection using internal and stability measures. 
The end user can also interact with the cluster analysis and these parameters by specifying the cl.method, cl.num and cl.dist parameters respectively.
}
\examples{
cl.analysis(city_data, cl.meth = "pam", clust.numb = 3)
}
\seealso{
\code{\link{cl.features}}, \code{\link[clValid]{clValid}}, \code{\link[cluster]{diana}}, \code{\link[cluster]{agnes}},
\code{\link[cluster]{pam}}, \code{\link[cluster]{clara}}, \code{\link[cluster]{fanny}}, \code{\link[mclust]{Mclust}}
}
\author{
Kleanthis Koupidis, Jaroslav Kuchar
}
