% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_spending.cl.R
\name{open_spending.cl}
\alias{open_spending.cl}
\title{Read and Calculate the Basic Information for Cluster Analysis Tasks from Open Spending API}
\usage{
open_spending.cl(json_data, dimensions=NULL, amounts=NULL, measured.dimensions=NULL,
cl.aggregate="sum", cl.method=NULL, cl.num=NULL, cl.dist="euclidean")
}
\arguments{
\item{json_data}{The json string, URL or file from Open Spending API}

\item{dimensions}{The dimensions/feature of the input data}

\item{amounts}{The measures of the input data}

\item{measured.dimensions}{The dimensions to which correspond amount/numeric variables}

\item{cl.aggregate}{Aggregate function of the input data}

\item{cl.method}{The clustering algorithm}

\item{cl.num}{The number of clusters}

\item{cl.dist}{The distance metric}
}
\value{
A json string with the resulted parameters of the \code{\link{cl.analysis}} function.
}
\description{
Extract and analyze the input data provided from Open Spending API, using the \code{\link{cl.analysis}} function.
}
\details{
This function is used to read data in json format from Open Spending API, in order to implement 
cluster analysis through \code{\link{cl.analysis}} function.
}
\seealso{
\code{\link{cl.analysis}}
}
\author{
Kleanthis Koupidis
}
