% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_var.R
\name{plot_var}
\alias{plot_var}
\title{Representation of the variables and their group membership}
\usage{
plot_var(resclv, K = NULL, axeh = 1, axev = 2, label = FALSE,
  cex.lab = 1, v_colors = NULL, v_symbol = FALSE, beside = FALSE)
}
\arguments{
\item{resclv}{results of CLV(), CLV_kmeans() or LCLV()}

\item{K}{the number of groups in the partition (already defined if CLV_kmeans is used)}

\item{axeh}{component number for the horizontal axis}

\item{axev}{component number for the vertical axis}

\item{label}{= TRUE :the column names in X are used as labels / = FALSE: no labels (by default)}

\item{cex.lab}{: magnification to be used for labels (1 by default)}

\item{v_colors}{default NULL. If missing colors are given, by default}

\item{v_symbol}{=TRUE : symbols are given isntead of colors for the identification of the groups/ =FALSE: no symbol (by default).}

\item{beside}{=TRUE : a plot per cluster of variables, side-by-side/ =FALSE :an unique plot with all the variables with the identification of their group membership (by default).}
}
\description{
Loading plot of the variables from a Principal Components Analysis. The group membership of the variables is superimposed.
}
\examples{
data(apples_sh)
resclvX <- CLV(X = apples_sh$senso, method = 1, sX = TRUE)
plot_var(resclvX, K = 4, axeh = 1, axev = 2)

}
