% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTRRef.R
\name{DTRRef}
\alias{DTRRef}
\title{Diurnal temperature range of multidimensional arrays}
\usage{
DTRRef(tmax, tmin, by.seasons = TRUE, dates = NULL, timedim = NULL,
  calendar = NULL, na.rm = TRUE, ncores = NULL)
}
\arguments{
\item{tmax}{A numeric multidimensional array containing daily maximum temperature.}

\item{tmin}{A numeric multidimensional array containing daily minimum temperature.}

\item{by.seasons}{If TRUE (by default), the DTR is computed for each season (December-January-February, March-April-May, June-July-August and September-October-November) seperately. If FALSE is specified, the montly mean DTR is computed.}

\item{dates}{A vector of dates with a calendar attributes. If NULL (by default), the 'time' attributes of parameter 'tmax' and 'tmin' are considered.}

\item{timedim}{An integer number indicating the position of the time dimension in the parameters \code{tmax} and \code{tmin}. If NULL (by default), the dimension called 'time' in parameter \code{tmax} and \code{tmin} is considered as time dimension.}

\item{calendar}{A character indicating the calendar type.}

\item{na.rm}{A logical indicating whether missing values should be removed. If \code{na.rm} is FALSE an NA value in any of the arguments will cause a value of NA to be returned, otherwise (TRUE by default) NA values are ignored.}

\item{ncores}{The number of cores to be used when computing the index.}
}
\value{
A list of length 2:
\itemize{
\item\code{$dtr.ref} {An array with the same dimensions as the input \code{data}, but with the time dimension reduce from daily to monthly or seasonal resolution depending on the selected resolution in \code{by.season}.}
\item\code{$season} {A vector of the season or months corresponding to the resolution selected in \code{by.season}}}
}
\description{
This function computes the mean diurnal temperature range (tmax - tmin).
}
\details{
The function returns a reordered array with 'time' dimension in the first position in the \code{dtr.ref} label.
}
\examples{
##Exmaple with synthetic data:
tmax <- 1:(2 * 3 * 365 * 1)
dim(tmax) <- c(lon = 2, lat = 3, time = 365, model = 1)
tmin <- (1:(2 * 3 * 365 * 1))-1
dim(tmin) <- c(lon = 2, lat = 3, time = 365, model = 1)
time <- seq.Date(as.Date("1900-01-01", format = "\%Y-\%d-\%m"), 
                as.Date("1900-31-12", format = "\%Y-\%d-\%m"), 1)
time <- as.POSIXct(time, tz = "CET")
metadata <- list(time = list(standard_name = 'time', long_name = 'time', 
                            calendar = 'noleap',
                            units = 'days since 1970-01-01 00:00:00', prec = 'double', 
                            dim = list(list(name ='time', unlim = FALSE))))
attr(time, "variables") <- metadata
attr(tmax, 'Variables')$dat1$time <- time
attr(tmax, 'Variables')$common[[2]]$dim[[3]]$len = length(time)
attr(tmax, 'Variables')$common[[2]]$dim[[3]]$vals <- time
attr(tmin, 'Variables')$dat1$time <- time
attr(tmin, 'Variables')$common[[2]]$dim[[3]]$len = length(time)
attr(tmin, 'Variables')$common[[2]]$dim[[3]]$vals <- time

a <- DTRRef(tmax, tmin, by.seasons = FALSE, ncores = NULL)
str(a)

tmax <- 1:(2 * 3 * 365 * 1)
dim(tmax) <- c(2, 3, 365)
tmin <- (1:(2 * 3 * 365 * 1))-1
dim(tmin) <- c(2, 3, 365)

a <- DTRRef(tmax, tmin, by.seasons = FALSE, dates = time,  timedim = 3, ncores = NULL)
str(a)
}

