% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_rankings.R
\name{build_rankings}
\alias{build_rankings}
\title{Build Plackett-Luce rankings}
\usage{
build_rankings(data = NULL, items = NULL, input = NULL,
  additional.rank = NULL, grouped.rankings = FALSE, ...)
}
\arguments{
\item{data}{a data frame with columns specified by items and input values to rank.}

\item{items}{a data frame or index of \code{data} for the column(s) containing the item names}

\item{input}{a data frame or index of \code{data} for the column(s) containing the values to be ranked}

\item{additional.rank}{optional, a data frame for the comparisons between tricot items and the local item}

\item{grouped.rankings}{optional, if TRUE return an object of class grouped_rankings}

\item{...}{additional arguments passed to methods}
}
\value{
a PlackettLuce "rankings" object, which is a matrix of dense rankings
}
\description{
Create an object of class "rankings" or "grouped_rankings" from tricot data
}
\examples{
 
# beans data where each observer compares 3 varieties randomly distributed 
# from a list of 11 and additionally compares these 3 varieties 
# with their local variety
library("PlackettLuce")
data("beans", package = "PlackettLuce")

# first build rankings with only tricot items
# and return an object of class 'rankings'
R <- build_rankings(data = beans,
                    items = c(1:3),
                    input = c(4:5))
head(R)

############################################################

# pass the comparison with local item as an additional rankings, then
# each of the 3 varieties are compared separately with the local item
# and return an object of class grouped_rankings
G <- build_rankings(data = beans,
                    items = c(1:3),
                    input = c(4:5),
                    additional.rank = beans[c(6:8)],
                    grouped.rankings = TRUE)
                    
head(G)

############################################################

# rankings with more than 3 items in a tricot project
# 5 items randomly assigned

input <- as.data.frame(matrix(NA, nrow = 5, ncol = 5))
names(input) <- paste0("position_item_",LETTERS[1:5])

for(s in 1:5) {
  input[s,] <- sample(1:5)
}

items <- randomise(5, 5, 5, c("green","blue","red","white","yellow"))

build_rankings(items = items, 
               input = input)


}
\seealso{
\code{\link[PlackettLuce]{rankings}} \code{\link[PlackettLuce]{grouped_rankings}}
}
