% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{vdtr}
\alias{vdtr}
\title{Mean daily difference DTR}
\usage{
vdtr(tmax, tmin, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{tmax}{maximum temperature}

\item{tmin}{minimum temperature}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
vDTR
}
\description{
Mean absolute day-to-day difference in DTR
}
\section{Formula}{
 \deqn{vDTR_j = \frac{ \sum_{ i = 1 } ^ { I } \mid ( TX_{ ij } - TN_{ ij } ) - ( TX_{i-1,j} -TN_{ i - 1,j }) \mid } {I}}
}

\examples{
data(data_all)
vdtr(tmax=data_all$tx, tmin=data_all$tn)
}
\references{
European Climate Assessment & Dataset. Indices dictionary. \url{https://www.ecad.eu//indicesextremes/indicesdictionary.php}
}
