% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kbdindex.R
\name{kbdindex}
\alias{kbdindex}
\title{Keetch-Byram drought index and Mac Arthur Drought Factor}
\usage{
kbdindex(dates, t, p, wrs = 5, start.date = NULL, what = "kbdi")
}
\arguments{
\item{dates}{Vector of dates. This is a character string in the form \code{d/m/y}}

\item{t}{Vector of daily temperature (in deg Celsius)}

\item{p}{Vector of daily accumulated preciptation (mm)}

\item{wrs}{Minimum total weekly precipitation value used to define a "rainy" week (in mm). Default to 5 mm. Ignored if  \code{start.date} is supplied.}

\item{start.date}{Starting date for computation. Default to \code{NULL}, meaning that the computation starts since the first input record. Otherwise,
the calculation starts the given date, that assumes a state of saturation of the soil (and hence KBDI=0, see Details), for instance just after snow melt.
This argument overrides \code{wrs}.}

\item{what}{What index should be returned by the function?. Current options include:
\itemize{
\item \code{kbdi}: Keetch-Byram Drought Index. This is the default.
\item \code{madf}: Mac Arthur's Drought Factor. Derived from the latter. See Details.
}}
}
\value{
A numeric vector containing the (daily) KBDI (or MADF) time series
}
\description{
Implementation of the Keetch Byram Drought Index and Mac Arthur's Drought Factor for vector data
}
\details{
The physical theory for the Keetch-Byram Drought Index (Keetch and Byram, 1968) is based on a number of assumptions: 
The first assumption is that soil moisture is at field capacity with a water depth equivalent to about 200 mm. 
The second assumption is that the rate of moisture loss in an area depends on the vegetation cover in the area, and vegetation density
 is a function of the mean annual rainfall. Hence, daily transpiration is approximated by an inverse exponential function of the mean annual rainfall.
  Finally, the evaporation rate of soil moisture with time is assumed to be an estimation of relative evapotranspiration from exponential 
  function of the daily maximum air temperature. Sensitivity analyses from earlier researchers have revealed that KBDI decays 
  exponentially with an assumed maximum soil water deficit and is sensitive to the daily maximum air 
  temperature (Dennison \emph{et al.}, 2013). Its values range from 0 to 800 (inches), with 800 in (203.2 mm after conversion) indicating extreme
  drought and zero indicating saturated soil.
 
The McArthur's Drought Factor was developed to predict the amount of fine fuel which would be available to be consumed in the flaming front of a fire.
 The predictive model used by McArthur was based on a combination of the Keetch Byram Drought Index, and the amount, and time since fall, of recent rain. That is the
 reason both indices are calculated by the same function.
}
\note{
The original equations of the code presented by Keetch and Byram (1968) were later corrected for two significant typographical errors
 affecting the index output Alexander (1990).
}
\references{
\itemize{
\item Keetch, J.J. and Byram, G.M. (1968) A drought index for forest fire control. USDA Forest Service.
\item Alexander, M.E., 1990. Computer calculation of the Keetch-Byram Drought Index - programmers beware. Fire Management Notes 51, 23–25.
\item Dennison, P.E., Roberts, D.A., Thorgusen, S.R., Regelbrugge, J.C., Weise, D., Christopher, L., 2003. Modeling seasonal changes in live fuel moisture and equivalent water thickness using a cumulative water balance index. Remote Sensing of the Environment 88, 442–452.
}
}
\author{
Joaquin Bedia-Jiménez
}
\keyword{internal}
