% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_descendant_edges.R
\name{find_descendant_edges}
\alias{find_descendant_edges}
\title{Gets descendant edges of an internal node}
\usage{
find_descendant_edges(n, tree)
}
\arguments{
\item{n}{An integer corresponding to the internal node for which the descendant edges are sought.}

\item{tree}{A tree as a phylo object.}
}
\description{
Returns all descendant edges of an internal node for a phylo object.
}
\details{
Returns a vector of integers corresponding to row numbers in \code{$edge} or cells in \code{$edge.length} of the descendant edges of the internal node supplied.
}
\examples{

# Create simple four-taxon tree:
tree <- ape::read.tree(text = "(A,(B,(C,D)));")

# Plot tree:
plot(tree)

# Show nodelabels:
nodelabels()

# Show edgelabels (note that edges 5 and 6
# are descendants of node 7):
edgelabels()

# Use find_descendant_edges to show that edges
# 5 and 6 are descendants of node 7:
find_descendant_edges(n = 7, tree = tree)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
