% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspectLvls.R
\name{inspectLvls}
\alias{inspectLvls}
\title{Inspect Levels for Contour Plots of Spectra2D Objects}
\usage{
inspectLvls(spectra, loading = NULL, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{loading}{Integer.  If a loadings entry is present, draw the histogram for it.
For example, if \code{loading = 1} \code{Loading_1} is used.}

\item{\dots}{Arguments to be passed downstream.}
}
\value{
A numeric vector giving the levels (invisibly).
}
\description{
Given a \code{Spectra2D} object, this function will assist in selecting levels
for preparing contour and image type plots.  The entire range of the data is
used in the histogram so you can choose levels that are suitable for any
particular spectrum.  However, loading matrices are excluded unless specified 
as the input. Any of the arguments to \code{\link{calcLvls}} can be used
to capture the computed levels, or you can choose by inspection.
}
\examples{

data(MUD1)
inspectLvls(MUD1, ylim = c(0, 50), main = "All MUD1 Data, mode = even")
inspectLvls(MUD1, ylim = c(0, 50), mode = "NMR",  main = "All MUD1 Data, mode = NMR")

}
\seealso{
See \code{\link{pfacSpectra2D}} for further examples.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
