% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfN_PolyaEggenberger.R
\name{cfN_PolyaEggenberger}
\alias{cfN_PolyaEggenberger}
\title{Characteristic function of Polya-Eggenberger}
\usage{
cfN_PolyaEggenberger(t, a, b, m, cfX)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{real number}

\item{b}{real number}

\item{m}{integer}

\item{cfX}{function}
}
\value{
characteristic function cf(t) of the Polya-Eggenberger distribution
}
\description{
cfN_PolyaEggenberger(t, a, b, m) evaluates the characteristic function cf(t) of the
Polya-Eggenberger distribution with the parameters a (a real), b (b real), and m (m integer), i.e.
cfN_PolyaEggenberger(t, a, b, m) = 2F1(-m,a,a+b,1-e^(1i*t))
where 2F1 denotes the Gauss hypergeometric function.

cfN_PolyaEggenberger(t, a, b, m) evaluates the compound characteristic function
cf(t) = cfN_PolyaEggenberge(-1i*log(cfX(t)), a, b, m), where cfX is function
handle of the characteristic function cfX(t) of a continuous distribution
and/or random variable X.

Note that such CF is characteristic function of the compound distribution,
i.e. distribution of the random variable Y = X_1 + ... + X_N, where X_i ~ F_X
are i.i.d. random variables with common CF cfX(t), and N ~ F_N is
independent RV with its CF given by cfN(t).
}
\examples{
## EXAMPLE1 (CF of the Polya-Eggenberger distribution with a = 2.2, b = 3.3, m = 4)
a <- 2.2
b <- 3.3
m <- 4
t <- seq(-15, 15, length.out = 1001)
plotGraf(function(t)
  cfN_PolyaEggenberger(t, a, b, m), t,
  title = "CF of the Polya-Eggenberger distribution with a = 2.2, b = 3.3, m = 4")

#' ## EXAMPLE2 (CF of the compound Polya-Eggenberger-Exponential distribution)
a <- 2.2
b <- 3.3
m <- 4
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfN_PolyaEggenberger(t, a, b, m, cfX), t,
  title = "CF of the compound Polya-Eggenberger-Exponential distribution")

## EXAMPLE3 (PDF/CDF of the compound Polya-Eggenberger-Exponential distribution)
a <- 2.2
b <- 3.3
m <- 4
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
cf <- function(t)
  cfN_PolyaEggenberger(t, a, b, m, cfX)
x <- seq(0, 2.5, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
Other Discrete Probability Distribution: \code{\link{cfN_Binomial}},
  \code{\link{cfN_Delaporte}},
  \code{\link{cfN_GeneralizedPoisson}},
  \code{\link{cfN_Geometric}},
  \code{\link{cfN_Logarithmic}},
  \code{\link{cfN_NegativeBinomial}},
  \code{\link{cfN_Poisson}}
}

