% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_prior_distribution.R
\name{get_prior_distribution}
\alias{get_prior_distribution}
\title{Get a prior distribution from priors}
\usage{
get_prior_distribution(model, n_draws = 4000)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{n_draws}{A scalar. Number of draws.}
}
\value{
A `data.frame` with dimension `n_param`x `n_draws` of possible
  lambda draws
}
\description{
Add to the model a `n_draws x n_param` matrix of possible parameters.
}
\examples{
make_model('X -> Y') \%>\%
  set_prior_distribution(n_draws = 5) \%>\%
  get_prior_distribution()
make_model('X -> Y') \%>\%
  get_prior_distribution(3)

}
\seealso{
Other prior_distribution: 
\code{\link{make_prior_distribution}()},
\code{\link{set_prior_distribution}()}
}
\concept{prior_distribution}
