% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model}
\alias{update_model}
\title{Fit causal model using 'stan'}
\usage{
update_model(model, data = NULL, data_type = "long", keep_fit = FALSE, ...)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{data}{A \code{data.frame}.  Data of nodes that can take three values: 0, 1, and NA. In long form as generated by \code{\link{make_events}}}

\item{data_type}{Either 'long' (as made by  \code{\link{simulate_data}}) or 'compact' (as made by \code{\link{collapse_data}}).
Compact data must have entries for each member of each strategy family to produce a valid simplex.}

\item{keep_fit}{Logical. Whether to append the  \code{\link[rstan]{stanfit}} object to the model. Defaults to `FALSE`}

\item{...}{Options passed onto \code{\link[rstan]{stan}} call.}
}
\value{
An object of class \code{causal_model}. It essentially returns a list containing the elements comprising
a model (e.g. 'statement', 'nodal_types' and 'DAG') with the `posterior_distribution` returned by \code{\link[rstan]{stan}} attached to it.
}
\description{
Takes a model and data and returns a model object with data attached and a posterior model
}
\examples{

model <- make_model('X->Y')
data_long   <- simulate_data(model, n = 4)
data_short  <- collapse_data(data_long, model)
\donttest{
model_1 <- update_model(model, data_long)
}
\dontrun{
# Throws error unless compact data indicated:

model_3 <- update_model(model, data_short)
}
\donttest{
model_4 <- update_model(model, data_short, data_type = 'compact')

# It is possible to implement updating without data, in which case the posterior
# is a stan object that reflects the prior
model5 <- update_model(model)

# Advanced: Example of a model with tailored parameters.
# We take a model and add a tailored P matrix (which maps from parameters
# to causal types) and a tailored parameters_df which reports that
# all parameters are in one family.
# Parameters in this example are not connected with nodal types in any way.
model <- make_model('X->Y')
P <- diag(8)
colnames(P) <- rownames(model$causal_types)
model <- set_parameter_matrix(model, P = P)
model$parameters_df <- data.frame(
  param_names = paste0('x',1:8),
  param_set = 1, priors = 1, parameters = 1/8)


# Update fully confounded model on strongly correlated data

data <- make_data(make_model('X->Y'), n = 100,
  parameters = c(.5, .5, .1,.1,.7,.1))
fully_confounded <- update_model(model, data, keep_fit = TRUE)
fully_confounded$stan_fit
query_model(fully_confounded, 'Y[X = 1] > Y[X=0]', using = 'posteriors')
# To see the confounding:
with(fully_confounded$posterior_distribution \%>\% data.frame(),
{par(mfrow = c(1,2))
 plot(x1, x5, main = 'joint distribution of X0.Y00, X0.Y01')
 plot(x1, x6, main = 'joint distribution of X0.Y00, X1.Y01')})
}

}
