% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\name{make_data}
\alias{make_data}
\title{Make data}
\usage{
make_data(
  model,
  n = 1,
  parameters = NULL,
  param_type = NULL,
  nodes = NULL,
  n_steps = NULL,
  probs = NULL,
  subsets = TRUE,
  complete_data = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{n}{Non negative integer. Number of observations.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.}

\item{param_type}{A character. String specifying type of parameters to make
("flat", "prior_mean", "posterior_mean", "prior_draw", "posterior_draw", "define").
With param_type set to \code{define} use arguments to be passed to \code{make_priors};
otherwise \code{flat} sets equal probabilities on each nodal type in each parameter set;
\code{prior_mean}, \code{prior_draw}, \code{posterior_mean}, \code{posterior_draw}
take parameters as the means or as draws from the prior or posterior.}

\item{nodes}{A \code{list}. Which nodes to be observed at each step}

\item{n_steps}{A \code{list}. Number of observations to be observed at each step}

\item{probs}{A \code{list}. Observation probabilities at each step}

\item{subsets}{A \code{list}. Strata within which observations are to be observed at each step}

\item{complete_data}{A \code{data.frame}. Dataset with complete observations. Optional.}

\item{...}{additional arguments that can be passed to \code{link{make_parameters}}}
}
\value{
A \code{data.frame} with simulated data.
}
\description{
Make data
}
\examples{


# Simple draws
model <- make_model("X -> M -> Y")
make_data(model)
make_data(model, n = 3, nodes = c("X","Y"))
make_data(model, n = 3, param_type = "prior_draw")
make_data(model, n = 10, param_type = "define", parameters =  0:9)

# Data Strategies
# A strategy in which X, Y are observed for sure and M is observed
# with 50\% probability for X=1, Y=0 cases

model <- make_model("X -> M -> Y")
make_data(
  model,
  n = 8,
  nodes = list(c("X", "Y"), "M"),
  probs = list(1, .5),
  subsets = list(NULL, "X==1 & Y==0"))

}
