% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_inherit_params.R
\name{CausalQueries_internal_inherit_params}
\alias{CausalQueries_internal_inherit_params}
\title{Create parameter documentation to inherit}
\usage{
CausalQueries_internal_inherit_params(
  model,
  query,
  join_by,
  parameters,
  P,
  A,
  data,
  data_events,
  node,
  statement,
  using,
  n_draws
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{query}{A character string. An expression defining nodal types to interrogate \code{\link{reveal_outcomes}}}

\item{join_by}{A logical operator. Used to connect causal statements: \emph{AND} ('&') or \emph{OR} ('|'). Defaults to '|'.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be provided to avoid repeated computation for simulations.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be provided to avoid repeated computation for simulations.}

\item{data}{A \code{data.frame}.  Data of nodes that can take three values: 0, 1, and NA. In long form as generated by \code{\link{make_events}}}

\item{data_events}{A \code{data.frame}. It must be compatible with nodes in \code{model}. The default columns are \code{event}, \code{strategy} and \code{count}.}

\item{node}{A character string. The quoted name of a node.}

\item{statement}{A character string. A quoted causal statement.}

\item{using}{A character string. It indicates whether to use `priors`, `posteriors` or `parameters`.}

\item{n_draws}{An integer. If no prior distribution is provided, generate prior distribution with \code{n_draws} number of draws.}
}
\value{
This function does not return anything. It is used to inherit roxygen documentation
}
\description{
Create parameter documentation to inherit
}
\keyword{internal}
