% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBRBase.R
\name{CBRBase}
\alias{CBRBase}
\title{Root class for common functionality of this package}
\description{
Root class for common functionality of this package

Root class for common functionality of this package
}
\keyword{datapreparation}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{the statistical model}

\item{\code{data}}{training data}

\item{\code{model_fit}}{trained object}

\item{\code{formula}}{Object of class formula or character describing the model fit}

\item{\code{terms}}{terms of the formula}

\item{\code{endPoint}}{Target variable}

\item{\code{distMat}}{A matrix with distances}

\item{\code{orderMat}}{A matrix with the order indices for similar cases search}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CBRBase-new}{\code{CBRBase$new()}}
\item \href{#method-CBRBase-fit}{\code{CBRBase$fit()}}
\item \href{#method-CBRBase-calc_distance_matrix}{\code{CBRBase$calc_distance_matrix()}}
\item \href{#method-CBRBase-get_similar_cases}{\code{CBRBase$get_similar_cases()}}
\item \href{#method-CBRBase-clone}{\code{CBRBase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CBRBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-CBRBase-new}{}}}
\subsection{Method \code{new()}}{
Initialize object for searching similar cases
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CBRBase$new(formula, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{Object of class formula or character describing the model fit}

\item{\code{data}}{}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CBRBase-fit"></a>}}
\if{latex}{\out{\hypertarget{method-CBRBase-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the Model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CBRBase$fit()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Training data of class data.frame}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CBRBase-calc_distance_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-CBRBase-calc_distance_matrix}{}}}
\subsection{Method \code{calc_distance_matrix()}}{
Calculates the distance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CBRBase$calc_distance_matrix(query = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query data of class data.frame}

\item{\code{x}}{Training data of class data.frame}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CBRBase-get_similar_cases"></a>}}
\if{latex}{\out{\hypertarget{method-CBRBase-get_similar_cases}{}}}
\subsection{Method \code{get_similar_cases()}}{
Extracts similar cases
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CBRBase$get_similar_cases(query, k = 1, addDistance = T, merge = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query data of class data.frame}

\item{\code{k}}{number of similar cases}

\item{\code{addDistance}}{Add distance to result data.frame}

\item{\code{merge}}{Add query data to matched cases data.frame}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CBRBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CBRBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CBRBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
